% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqpac_generics_methods.R
\name{names,PAC-method}
\alias{names,PAC-method}
\alias{names,reanno-method}
\title{names of objects in reanno}
\usage{
\S4method{names}{PAC}(x)

\S4method{names}{reanno}(x)
}
\arguments{
\item{x}{A S4 object of class PAC.}
}
\value{
The names of the content in a PAC-object.

Names of the items in the reanno-object.
}
\description{
names of objects in reanno
}
\examples{

load(system.file("extdata", "drosophila_sRNA_pac_filt_anno.Rdata", 
                  package = "seqpac", mustWork = TRUE))

# extra fuctionality with s4 PAC-object:
names(pac)
length(pac)
nrow(pac)
ncol(pac)
rownames(pac)
colnames(pac)
pheno(pac) 
head(anno(pac))
head(counts(pac))
head(norm(pac)$cpm)

######################################################### 
##### Create a reanno object

##  First load a PAC- object

 load(system.file("extdata", "drosophila_sRNA_pac_filt_anno.Rdata", 
                   package = "seqpac", mustWork = TRUE))
 anno(pac) <- anno(pac)[,1, drop = FALSE]
 
 
##  Then specify paths to fasta references
# If you are having problem see the vignette small RNA guide for more info.
 
 trna_path <- system.file("extdata/trna", "tRNA.fa", 
                          package = "seqpac", mustWork = TRUE)  
 rrna_path <- system.file("extdata/rrna", "rRNA.fa", 
                          package = "seqpac", mustWork = TRUE)
 
 ref_paths <- list(trna= trna_path, rrna= rrna_path)
                                    
##  Add output path of your choice.
# Here we use the R temporary folder depending on platform
if(grepl("windows", .Platform$OS.type)){
 output <- paste0(tempdir(), "\\\\seqpac\\\\test")
}else{
 output <- paste0(tempdir(), "/seqpac/test")}

## Make sure it is empty (otherwise you will be prompted for a question)
out_fls  <- list.files(output, recursive=TRUE)
closeAllConnections()
suppressWarnings(file.remove(paste(output, out_fls, sep="/")))

##  Then map your PAC-object against the fasta references
 map_reanno(pac, input=ref_paths, output=output,
               type="internal", mismatches=2,  import="biotype", 
               threads=2, keep_temp=FALSE)

##  Then generate a reanno-object of the temporary bowtie-files 
reanno_object <- make_reanno(output, PAC=pac, mis_fasta_check = TRUE)

## Accessing content and S4/S3 conversion:
names(reanno_object)
overview(reanno_object)
full(reanno_object)
rownames(reanno_object)
length(reanno_object)
nrow(reanno_object)
reanno_s3 <- as(reanno_object, "list")
reanno_s4 <- as.reanno(reanno_s3) 
}
\seealso{
Other PAC methods: 
\code{\link{anno}()},
\code{\link{counts}()},
\code{\link{norm}()},
\code{\link{pheno}()},
\code{\link{show.PAC}()},
\code{\link{summary}()}
}
\concept{PAC methods}
