% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality_trim.R
\name{quality_trim}
\alias{quality_trim}
\title{Trim poor quality samples using cutadapt.}
\usage{
quality_trim(
  per_base,
  per_seq,
  pair,
  threads = 4,
  scRNA = FALSE,
  cutadapt_add = NULL
)
}
\arguments{
\item{per_base}{samples with poor per base sequence quality.}

\item{per_seq}{samples with poor per sequence quality scores.}

\item{pair}{'single' for single-end (SE) or 'paired' for paired-end (PE) reads.}

\item{threads}{the number of threads to be used. Default is 4.}

\item{scRNA}{logic, whether single-cell RNA-seq is quantified or not. Default is FALSE.}

\item{cutadapt_add}{additional parameters to customize cutadapt to trim poor quality reads. Default is NULL}
}
\value{
None
}
\description{
Trim poor quality samples using cutadapt based on the results from quality_test().
}
\examples{

quality_trim(per_base = 'test_read_2.fastq', per_seq = 'test_read_2.fastq',
             pair = 'paired', threads = 4, scRNA = TRUE)

}
