% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zinb_fit.R
\name{zinbOptimize}
\alias{zinbOptimize}
\title{Optimize the parameters of a ZINB regression model}
\usage{
zinbOptimize(
  m,
  Y,
  commondispersion = TRUE,
  maxiter = 25,
  stop.epsilon = 1e-04,
  verbose = FALSE,
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{m}{The model of class ZinbModel}

\item{Y}{The matrix of counts.}

\item{commondispersion}{Whether the dispersion is the same for all features
(default=TRUE)}

\item{maxiter}{maximum number of iterations (default 25)}

\item{stop.epsilon}{stopping criterion, when the relative gain in
likelihood is below epsilon (default 0.0001)}

\item{verbose}{print information (default FALSE)}

\item{BPPARAM}{object of class \code{bpparamClass} that specifies the
back-end to be used for computations. See
\code{\link[BiocParallel]{bpparam}} for details.}
}
\value{
An object of class ZinbModel similar to the one given as argument
  with modified parameters alpha_mu, alpha_pi, beta_mu, beta_pi, gamma_mu,
  gamma_pi, W.
}
\description{
The parameters of the model given as argument are optimized by penalized
maximum likelihood on the count matrix given as argument. It is recommended
to call zinb_initialize before this function to have good starting point for
optimization, since the optimization problem is not convex and can only
converge to a local minimum.
}
\examples{
Y = matrix(10, 3, 5)
m = zinbModel(n=NROW(Y), J=NCOL(Y))
m = zinbInitialize(m, Y, BPPARAM=BiocParallel::SerialParam())
m = zinbOptimize(m, Y, BPPARAM=BiocParallel::SerialParam())
}
