% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zinb_fit.R
\name{zinb.loglik.regression}
\alias{zinb.loglik.regression}
\title{Penalized log-likelihood of the ZINB regression model}
\usage{
zinb.loglik.regression(
  alpha,
  Y,
  A.mu = matrix(nrow = length(Y), ncol = 0),
  B.mu = matrix(nrow = length(Y), ncol = 0),
  C.mu = matrix(0, nrow = length(Y), ncol = 1),
  A.pi = matrix(nrow = length(Y), ncol = 0),
  B.pi = matrix(nrow = length(Y), ncol = 0),
  C.pi = matrix(0, nrow = length(Y), ncol = 1),
  C.theta = matrix(0, nrow = length(Y), ncol = 1),
  epsilon = 0
)
}
\arguments{
\item{alpha}{the vectors of parameters c(a.mu, a.pi, b) concatenated}

\item{Y}{the vector of counts}

\item{A.mu}{matrix of the model (see Details, default=empty)}

\item{B.mu}{matrix of the model (see Details, default=empty)}

\item{C.mu}{matrix of the model (see Details, default=zero)}

\item{A.pi}{matrix of the model (see Details, default=empty)}

\item{B.pi}{matrix of the model (see Details, default=empty)}

\item{C.pi}{matrix of the model (see Details, default=zero)}

\item{C.theta}{matrix of the model (see Details, default=zero)}

\item{epsilon}{regularization parameter. A vector of the same length as
\code{alpha} if each coordinate of \code{alpha} has a specific
regularization, or just a scalar is the regularization is the same for all
coordinates of \code{alpha}. Default=\code{O}.}
}
\value{
the penalized log-likelihood.
}
\description{
This function computes the penalized log-likelihood of a ZINB regression
model given a vector of counts.
}
\details{
The regression model is parametrized as follows: \deqn{log(\mu) =
  A_\mu * a_\mu + B_\mu * b + C_\mu} \deqn{logit(\Pi) = A_\pi * a_\pi + B_\pi
  * b} \deqn{log(\theta) = C_\theta} where \eqn{\mu, \Pi, \theta} are
  respectively the vector of mean parameters of the NB distribution, the
  vector of probabilities of the zero component, and the vector of inverse
  dispersion parameters. Note that the \eqn{b} vector is shared between the
  mean of the negative binomial and the probability of zero. The
  log-likelihood of a vector of parameters \eqn{\alpha = (a_\mu; a_\pi; b)}
  is penalized by a regularization term \eqn{\epsilon ||\alpha||^2 / 2} is
  \eqn{\epsilon} is a scalar, or \eqn{\sum_{i}\epsilon_i \alpha_i^2 / 2} is
  \eqn{\epsilon} is a vector of the same size as \eqn{\alpha} to allow for
  differential regularization among the parameters.
}
