% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeTissueAware.R
\name{normalizeTissueAware}
\alias{normalizeTissueAware}
\title{Normalize in a tissue aware context}
\source{
The function qsmooth comes from the qsmooth packages
currently available on github under user 'kokrah'.
}
\usage{
normalizeTissueAware(obj, groups, normalizationMethod = c("qsmooth",
  "quantile"), ...)
}
\arguments{
\item{obj}{ExpressionSet object}

\item{groups}{Vector of labels for each sample or a column name of the phenoData slot
for the ids to filter. Default is the column names}

\item{normalizationMethod}{Choice of 'qsmooth' or 'quantile'}

\item{...}{Options for \code{\link{qsmooth}} function or \code{\link[limma]{normalizeQuantiles}}}
}
\value{
ExpressionSet object with an assayData called normalizedMatrix
}
\description{
This function provides a wrapper to various normalization methods developed.
Currently it only wraps qsmooth and quantile normalization returning a log-transformed
normalized matrix. qsmooth is a normalization approach that normalizes samples in
a condition aware manner.
}
\examples{
data(skin)
normalizeTissueAware(skin,"SMTSD")

}
