% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterSamples.R
\name{filterSamples}
\alias{filterSamples}
\title{Filter samples}
\usage{
filterSamples(obj, ids, groups = colnames(obj), keepOnly = FALSE)
}
\arguments{
\item{obj}{ExpressionSet object.}

\item{ids}{Names found within the groups labels corresponding to samples to be removed}

\item{groups}{Vector of labels for each sample or a column name of the phenoData slot
for the ids to filter. Default is the column names.}

\item{keepOnly}{Filter or keep only the samples with those labels.}
}
\value{
Filtered ExpressionSet object
}
\description{
Filter samples
}
\examples{
data(skin)
filterSamples(skin,ids = "Skin - Not Sun Exposed (Suprapubic)",groups="SMTSD")
filterSamples(skin,ids=c("GTEX-OHPL-0008-SM-4E3I9","GTEX-145MN-1526-SM-5SI9T"))

}
