\name{xmap.plot}
\alias{xmap.plot}
\alias{xmap.points}
\title{ Utility methods for quick graph generation }
\description{
  These methods attempt to provide a simpler interface for generating X:Map graphs.
}
\usage{
  xmap.plot( x, y, species=c("homo_sapiens","mus_musculus","rattus_norvegicus"), 
             chr, xlim, ylim, main, sub, 
             type=c("scatter", "line", "bar", "step", "area", "steparea"), 
             xlab, ylab = "value", col, dp=2, projectid )
  xmap.points( x, y, type=c("scatter", "line", "bar", "step", "area", "steparea"),
             xlab, col, dp=2, graphid )
}
\arguments{
  \item{x}{ The points for the x-axis of this plot.  These points must be offsets from the start of the graph, and not their actual chromosomal location }
  \item{y}{ The points for the y-axis of this plot.  Points where min>y or y >max will not be displayed }
  \item{species}{ The species that this graph is to be drawn on }
  \item{chr}{ A string representing the chromosome this graph is to be drawn on }
  \item{xlim}{ A range object describing the min and max BP for this graph.  If ommitted, we call range on the x parameter }
  \item{ylim}{ The maximum and minimum Y value for the graph.  If ommitted, we call range on the y parameter }
  \item{main}{ The main title }
  \item{sub}{ A sub-title for this graph }
  \item{type}{ The type of graph you wish to draw }
  \item{xlab}{ The label for this plot }
  \item{ylab}{ The label for the yaxis of this graph }
  \item{col}{ The colour of the graph defined as an integer in the format 0xAARRGGBB.  See \code{\link{xmap.col}} }
  \item{dp}{ The number of decimal places you want to save for the y-coordinates }
  \item{projectid}{ The projectid (returned by \code{\link{xmap.project.new}} and as a list from \code{\link{xmap.project.list}}.  If this is not passed, on the first time of calling a new project will be created, and will be used on all subsequent calls) }
  \item{graphid}{ The graphid returned by \code{\link{xmap.graph.new}} or \code{\link{xmap.graph.list}}.  If this is not passed, it will use the last graph generated by \code{\link{xmap.plot}}. }
}
\author{
  Tim Yates
}
\seealso{ 
  \code{\link{xmap.col}}\cr
  \code{\link{xmap.project.new}}\cr
  \code{\link{xmap.project.list}}\cr
  \code{\link{xmap.project.load}}\cr
  \code{\link{xmap.project.save}}\cr
  \code{\link{xmap.project.delete}}\cr
  \code{\link{xmap.graph.new}}\cr
  \code{\link{xmap.graph.list}}\cr
  \code{\link{xmap.graph.load}}\cr
  \code{\link{xmap.graph.save}}\cr
  \code{\link{xmap.graph.delete}}\cr
  \code{\link{xmap.plot.new}}\cr
  \code{\link{xmap.plot.list}}\cr
  \code{\link{xmap.plot.load}}\cr
  \code{\link{xmap.plot.save}}\cr
  \code{\link{xmap.plot.delete}}\cr
}
\examples{
  \dontshow{
    path     <- tempdir()
    old.path <- Sys.getenv( "XMAP_BRIDGE_CACHE" )
    Sys.setenv( XMAP_BRIDGE_CACHE=path )
  }
  x <- seq( 1000, 100000, by = 1000 )
  y <- runif( length( x ), -10, 10 )

  # This will create a new project, and graph, and add a plot to it
  xmap.plot( x, y, species="homo_sapiens", "1", main="A quick graph", 
             sub="Sub heading", type="area", xlab="Plot 1", col=0xAAFFBB00 )

  # This will add another plot to the same graph
  xmap.points( x, y, type="area", xlab="Plot 2", col=0xAA0000FF )
  \dontshow{
    Sys.setenv( XMAP_BRIDGE_CACHE=old.path )
  }
}
