% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ingest_xen.R
\name{ingest_xen}
\alias{ingest_xen}
\title{produce a pre-loaded XenSPEP (SpatialExperiment with parquet references)}
\usage{
ingest_xen(folder)
}
\arguments{
\item{folder}{character(1) 'standard' Xenium output folder}
}
\value{
instance of XenSPEP
}
\description{
produce a pre-loaded XenSPEP (SpatialExperiment with parquet references)
}
\examples{
chkns <- function(pkstring) {
  if (!requireNamespace(pkstring)) {
    message(sprintf("install \%s to use this feature; returning NULL", pkstring))
    return(NULL)
  }
}
chkns("SFEData")
chkns("HDF5Array")
chkns("SingleCellExperiment")
if (requireNamespace("SFEData")) {
  td <- tempdir()
  z <- SFEData::XeniumOutput("v2", td)
  ii <- ingest_xen(file.path(td, "xenium2"))
  print(validObject(ii))
  plot(SpatialExperiment::spatialCoords(ii), pch = ".")
}
}
