% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{prepareCountsForRegression}
\alias{prepareCountsForRegression}
\title{Process count matrix for expression modeling}
\usage{
prepareCountsForRegression(
  counts,
  design,
  base_lvl,
  log2 = TRUE,
  pseudo_count = 1L,
  drop_base_lvl = TRUE
)
}
\arguments{
\item{counts}{matrix of read counts.}

\item{design}{matrix giving the design matrix for the samples. Columns
corresponds to samples groups and rows to samples names.}

\item{base_lvl}{string indicating group in \code{design} corresponding to
basal expression level. The reference samples to which expression change
will be compared.}

\item{log2}{logical flag indicating if counts should be log2(counts per
million) should be returned.}

\item{pseudo_count}{integer count to be added before taking log2.}

\item{drop_base_lvl}{logical flag indicating if \code{base_lvl} samples
should be dropped from resulting MultiAssayExperiment object.}
}
\value{
MultiAssayExperiment object with two experiments:
\describe{
\item{U}{matrix giving expression values averaged over basal level samples}
\item{Y}{matrix of expression values}
}
design with \code{base_lvl} dropped is stored in metadata and directly
available for \code{modelGeneExpression}.
}
\description{
Expression counts are processed using \link[edgeR]{edgeR} following
\href{https://bioconductor.org/packages/release/bioc/vignettes/edgeR/inst/doc/edgeRUsersGuide.pdf}{User's Guide}.
Shortly, counts for each sample are filtered for lowly expressed promoters,
normalized for the library size and transformed into counts per million (CPM).
Optionally, CPM are log2 transformed with addition of pseudo count. Basal
level expression is calculated by averaging \code{base_lvl} samples
expression values.
}
\examples{
data("rinderpest_mini")
base_lvl <- "00hr"
design <- matrix(
  data = c(1, 0, 0,
           1, 0, 0,
           1, 0, 0,
           0, 1, 0,
           0, 1, 0,
           0, 1, 0,
           0, 0, 1,
           0, 0, 1,
           0, 0, 1),
  ncol = 3,
  nrow = 9,
  byrow = TRUE,
  dimnames = list(colnames(rinderpest_mini), c("00hr", "12hr", "24hr")))
mae <- prepareCountsForRegression(
  counts = rinderpest_mini,
  design = design,
  base_lvl = base_lvl)

}
