% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{getInteractionMatrix}
\alias{getInteractionMatrix}
\title{Compute interaction matrix}
\usage{
getInteractionMatrix(a, b, ext = 500, count = FALSE)
}
\arguments{
\item{a}{GRanges object.}

\item{b}{GRanges object.}

\item{ext}{Integer specifying number of base pairs the \code{a} coordinates
should be extended in upstream and downstream directions.}

\item{count}{Logical indicating if matrix should hold number of overlaps
between \code{a} and \code{b} or if FALSE presence / absence indicators.}
}
\value{
Sparse matrix of class dgCMatrix, with rows corresponding to
\code{a} and columns to \code{b}. Each cell holds a number indicating
how many times \code{a} and \code{b} overlapped.
}
\description{
\code{getInteractionMatrix} construct interaction matrix between two Granges
objects. Names of object \code{a} became row names and names of \code{b}
column names.
}
\examples{
a <- GenomicRanges::GRanges(
  seqnames = c("chr20", "chr4"),
  ranges = IRanges::IRanges(
    start = c(62475984L, 173530220L),
    end = c(62476001L, 173530236L)),
  strand = c("-", "-"),
  name = c("hg19::chr20:61051039..61051057,-;hg_188273.1",
           "hg19::chr4:174451370..174451387,-;hg_54881.1"))
b <- GenomicRanges::GRanges(
  seqnames = c("chr4", "chr20"),
  ranges = IRanges::IRanges(
    start = c(173530229L, 63864270L),
    end = c(173530236L, 63864273L)),
  strand = c("-", "-"),
  name = c("HAND2", "GATA5"))
getInteractionMatrix(a, b)

}
