% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-xcmsRaw.R
\name{findPeaks.matchedFilter,xcmsRaw-method}
\alias{findPeaks.matchedFilter,xcmsRaw-method}
\alias{findPeaks.matchedFilter}
\title{Peak detection in the chromatographic time domain}
\usage{
\S4method{findPeaks.matchedFilter}{xcmsRaw}(
  object,
  fwhm = 30,
  sigma = fwhm/2.3548,
  max = 5,
  snthresh = 10,
  step = 0.1,
  steps = 2,
  mzdiff = 0.8 - step * steps,
  index = FALSE,
  sleep = 0,
  scanrange = numeric()
)
}
\arguments{
\item{object}{The \code{xcmsRaw} object on which peak detection
should be performed.}

\item{fwhm}{\code{numeric(1)} specifying the full width at half maximum
of matched filtration gaussian model peak. Only used to calculate the
actual sigma, see below.}

\item{sigma}{\code{numeric(1)} specifying the standard deviation (width)
of the matched filtration model peak.}

\item{max}{\code{numeric(1)} representing the maximum number of peaks
that are expected/will be identified per slice.}

\item{snthresh}{\code{numeric(1)} defining the signal to noise cutoff
to be used in the chromatographic peak detection step.}

\item{step}{numeric(1) specifying the width of the bins/slices in m/z
dimension.}

\item{steps}{\code{numeric(1)} defining the number of bins to be
merged before filtration (i.e. the number of neighboring bins that will
be joined to the slice in which filtration and peak detection will be
performed).}

\item{mzdiff}{\code{numeric(1)} defining the minimum difference
in m/z for peaks with overlapping retention times}

\item{index}{\code{logical(1)} specifying whether indicies should be
returned instead of values for m/z and retention times.}

\item{sleep}{(DEPRECATED). The use of this parameter is highly discouraged,
as it could cause problems in parallel processing mode.}

\item{scanrange}{Numeric vector defining the range of scans to which the
original \code{object} should be sub-setted before peak detection.}
}
\value{
A matrix, each row representing an intentified chromatographic peak.
}
\description{
Find peaks in the chromatographic time domain of the
profile matrix. For more details see
\code{\link[=do_findChromPeaks_matchedFilter]{do_findChromPeaks_matchedFilter()}}.
}
\references{
Colin A. Smith, Elizabeth J. Want, Grace O'Maille, Ruben Abagyan and
Gary Siuzdak. "XCMS: Processing Mass Spectrometry Data for Metabolite
Profiling Using Nonlinear Peak Alignment, Matching, and Identification"
\emph{Anal. Chem.} 2006, 78:779-787.
doi: \href{https://doi.org/10.1021/ac051437y}{10.1021/ac051437y}
}
\author{
Colin A. Smith
}
\concept{Old peak detection methods}
