% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Annot_functions.R
\name{functional_annot}
\alias{functional_annot}
\title{Functional similarity score based on ontology}
\usage{
functional_annot(annot, gene_i, gene_j)
}
\arguments{
\item{annot}{Processed annotation data as provided by
\code{\link{process_annot}}.}

\item{gene_i}{String with the gene symbol in the row of the adjacency
matrix.}

\item{gene_j}{String with the gene symbol in the column of the adjacency
matrix.}
}
\value{
Numeric value with GO/HPO functional similarity between given
    pair of proteins.
}
\description{
Functional similarity between two genes in ontology databases (GO or HPO).
Each pair of interacting proteins in the PPI graph network, is
quantified the shared annotations between them using the Fisher's combined
probability test (\url{https://doi.org/10.1007/978-1-4612-4380-9_6}). This
is based on the number of genes annotated in each shared ontology term and
the total amount of unique genes available in the ontology database.
}
\examples{
hpo <- wppi_hpo_data()
hpo <- process_annot(hpo)
hpo_score <- functional_annot(hpo, 'AKT1', 'MTOR')
# [1] 106.9376

}
\seealso{
\itemize{
    \item{\code{\link{process_annot}}}
    \item{\code{\link{weighted_adj}}}
}
}
