% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WPPI_functions.R
\name{common_neighbors}
\alias{common_neighbors}
\title{Shared neighbors of connected vertices}
\usage{
common_neighbors(graph_op)
}
\arguments{
\item{graph_op}{Igraph object based on OmniPath PPI interactions from
\code{\link{graph_from_op}}.}
}
\value{
Data frame (tibble) with igraph vertex IDs of connected pairs of
    vertices (source and target), a list column with the IDs of their
    common neighbors, and a column with the number of neighbors.
}
\description{
For each interacting pair of proteins in the PPI network, store the nodes
of the common neighbors. This function works for any igraph graph.
}
\examples{
graph_op <- graph_from_op(wppi_omnipath_data())
genes_interest <-
    c("ERCC8", "AKT3", "NOL3", "GFI1B", "CDC25A", "TPX2", "SHE")
graph_op_1 <- subgraph_op(graph_op, genes_interest, 1)
shared_neighbors <- common_neighbors(graph_op_1)

}
\seealso{
\code{\link{graph_from_op}}
}
