% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_solve_cell.R
\name{solveCell}
\alias{solveCell}
\title{Affects a sample to the chosen cell in the plate}
\usage{
solveCell(m, d, i, j, already_drawn, constraint)
}
\arguments{
\item{m}{Matrix representing the plate plan.}

\item{d}{Dataframe containing the samples to place.}

\item{i}{Line index of the chosen well.}

\item{j}{Column index of the chosen well.}

\item{already_drawn}{Vector of samples already affected to wells.}

\item{constraint}{Character. Corresponds to the neighborhood constraint mode.}
}
\value{
If there is no possibility to find a valid sample, the function
returns an error value (1).
If a sample is chosen, then this function returns two objects:
* __m__ The matrix updated with the new added sample.
* __already_drawn__ The vector of already placed samples updated.
}
\description{
This function chooses a sample randomly from among those who respect the
neighborhood constraints and who have not yet been assigned to a well.
}
