% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiggleplotr.R
\name{plotCoverageData}
\alias{plotCoverageData}
\title{Plot read coverage across a genomic region}
\usage{
plotCoverageData(
  coverage_data_list,
  heights = c(0.75, 0.25),
  alpha = 1,
  fill_palette = c("#a1dab4", "#41b6c4", "#225ea8"),
  connect_exons = TRUE,
  transcript_label = TRUE,
  return_subplots_list = FALSE,
  coverage_type = "area",
  show_legend = FALSE
)
}
\arguments{
\item{coverage_data_list}{List of required from the extractCoverageData function:
\itemize{
 \item exons - list of GRanges objects, each object containing exons for one transcript.
 \item cdss - list of GRanges objects, each object containing the coding regions (CDS) of a single transcript. 
 \item plotting_annotations - Transcript labels for plotting.
 \item tx_annotations - Transcript coordinates for plotting.
 \item xlabel - Label of the x-axis.
 \item coverage_df - Read coverage data frame.
 \item limits - x-axis limits.
}}

\item{heights}{Specifies the proportion of the height that is dedicated to coverage plots (first value) 
relative to transcript annotations (second value). (default: c(0.75,0.25))}

\item{alpha}{Transparency (alpha) value for the read coverage tracks. 
Useful to set to something < 1 when overlaying multiple tracks (see track_id). (default: 1)}

\item{fill_palette}{Vector of fill colours used for the coverage tracks. Length must be equal to the number of 
unique values in track_data$colour_group column.}

\item{connect_exons}{Print lines that connect exons together. Set to FALSE when plotting peaks (default: TRUE).}

\item{transcript_label}{If TRUE then transcript labels are printed above each transcript. (default: TRUE).}

\item{return_subplots_list}{Instead of a joint plot return a list of subplots that can be joined together manually.}

\item{coverage_type}{Specifies if the read coverage is represented by either 'line', 'area' or 'both'. 
The 'both' option tends to give better results for wide regions. (default: area).}

\item{show_legend}{display legend for the colour_group next to the read coverage plot (default: FALSE).}
}
\value{
Either object from cow_plot::plot_grid() function or a list of subplots (if return_subplots_list == TRUE)
}
\description{
Does not work on Windows, because rtracklayer cannot read BigWig files on Windows.
}
\examples{
require("dplyr")
require("GenomicRanges")
sample_data = dplyr::data_frame(sample_id = c("aipt_A", "aipt_C", "bima_A", "bima_C"), 
    condition = factor(c("Naive", "LPS", "Naive", "LPS"), levels = c("Naive", "LPS")), 
    scaling_factor = 1) \%>\%
    dplyr::mutate(bigWig = system.file("extdata",  paste0(sample_id, ".str2.bw"), package = "wiggleplotr"))

track_data = dplyr::mutate(sample_data, track_id = condition, colour_group = condition)

selected_transcripts = c("ENST00000438495", "ENST00000392477") #Plot only two transcripts of the gens
\dontrun{
cov_data = extractCoverageData(ncoa7_exons[selected_transcripts], ncoa7_cdss[selected_transcripts], ncoa7_metadata, track_data)
plotCoverageData(cov_data, heights = c(2,1), fill_palette = getGenotypePalette())
}

}
