% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{weitrix_calibrate}
\alias{weitrix_calibrate}
\title{Adjust weights row-wise based on given row dispersions}
\usage{
weitrix_calibrate(weitrix, dispersions)
}
\arguments{
\item{weitrix}{A weitrix object, or an object that can be converted to a weitrix 
with \code{as_weitrix}.}

\item{dispersions}{A dispersion for each row.}
}
\value{
A SummarizedExperiment object with metadata fields marking it as a weitrix.
}
\description{
Based on estimated row dispersions, adjust weights in each row.
}
\details{
For large numbers of samples this can be based directly 
on weitrix_dispersions. 
For small numbers of samples, when using limma, 
it should be based on a trend-line fitted to known co-variates of 
the dispersions. 
This can be done using \code{weitrix_calibrate_trend}.
}
\examples{
# Adjust weights so dispersion for each row is exactly 1. This is dubious 
# for a small dataset, but would be fine for a dataset with many columns.
comp <- weitrix_components(simwei, p=1, verbose=FALSE)
disp <- weitrix_dispersions(simwei, comp)
cal <- weitrix_calibrate(simwei, disp)
weitrix_dispersions(cal, comp)

}
