% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift.R
\name{counts_shift}
\alias{counts_shift}
\title{Produce a weitrix of shift scores}
\usage{
counts_shift(counts, grouping, verbose = TRUE, typecast = identity)
}
\arguments{
\item{counts}{A matrix of read counts. Rows are peaks and columns are samples.}

\item{grouping}{A data frame defining the grouping of peaks into genes. 
Should have a column "group" naming the gene and 
    a column "name" naming the peak 
    (corresponding to \code{rownames(counts)}). 
Within each group, peak names should be ordered from 5' to 3' position.}

\item{verbose}{If TRUE, output some debugging and progress information.}

\item{typecast}{A function to convert a matrix to a matrix-like type.
Applied at the chunk level, before all chunks are \code{rbind}ed.
Allows use of memory-efficient matrix representations.}
}
\value{
A SummarizedExperiment object with metadata fields marking it as a weitrix.
}
\description{
Produce a weitrix of shift scores between -1 and 1. The input is read counts
at a collection of peaks (or other features) in a collection of samples. The
peaks can be grouped by gene, and are ordered within each gene.
}
\details{
For a particular gene, a shift score measures measures the tendency of 
reads to be upstrand (negative) or downstrand (positive) of 
the average over all samples. 
Shift scores range between -1 and 1.
}
\examples{
grouping <- data.frame(
    group=c("A","A","A","B","B"),
    name=c("p1","p2","p3","p4","p5"))

counts <- rbind(
    p1=c(1,2,0),
    p2=c(0,1,0),
    p3=c(1,0,0),
    p4=c(0,0,1),
    p5=c(0,2,1))

wei <- counts_shift(counts, grouping)

weitrix_x(wei)
weitrix_weights(wei)
rowData(wei)

}
