% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{squared_wass_approx}
\alias{squared_wass_approx}
\title{Compute approximated squared 2-Wasserstein distance}
\usage{
squared_wass_approx(x, y)
}
\arguments{
\item{x}{sample (vector) representing the distribution of condition \eqn{A}}

\item{y}{sample (vector) representing the distribution of condition \eqn{B}}
}
\value{
The approximated squared 2-Wasserstein distance between \eqn{x} and \eqn{y}
}
\description{
Calculates an approximated squared 2-Wasserstein distance based on the mean squared difference between 1000 equidistant
quantiles corresponding to the empirical distributions of two input vectors \eqn{x} and \eqn{y}
}
\examples{
set.seed(24)
x<-rnorm(100)
y1<-rnorm(150)
y2<-rexp(150,3)
y3<-rpois(150,2)

squared_wass_approx(x,y1)
squared_wass_approx(x,y2)
squared_wass_approx(x,y3)

}
\references{
Schefzik, R., Flesch, J., and Goncalves, A. (2020). waddR: Using the 2-Wasserstein distance to identify differences between distributions in two-sample testing, with application to single-cell RNA-sequencing data.
}
\seealso{
See the functions \code{wasserstein_metric} and \code{squared_wass_decomp} for
alternative implementations of the 2-Wasserstein distance
}
