% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vulcan.R
\name{vulcan.import}
\alias{vulcan.import}
\title{Function to import BAM files}
\usage{
vulcan.import(sheetfile, intervals = NULL)
}
\arguments{
\item{sheetfile}{path to a csv annotation file containing sample information
and BAM location}

\item{intervals}{size of the peaks. If NULL (default) it is inferred from
the average fragment length observed in the dataset}
}
\value{
A list of components:
\describe{
\item{peakcounts}{A matrix of raw peak counts, peaks as rows, samples as
columns}
\item{peakrpkms}{A matrix of peak RPKMs, peaks as rows, samples as
columns}
\item{samples}{A vector of sample names and conditions}
}
}
\description{
This function coalesces and annotates a set of BAM files into peak-centered
data
}
\examples{
library(vulcandata)
# Generate an annotation file from the dummy ChIP-Seq dataset
vfile<-tempfile()
vulcandata::vulcansheet(vfile)
# Import BAM and BED information into a list object
# vobj<-vulcan.import(vfile)
# This vobj is identical to the object returned by
# vulcandata::vulcanexample()
unlink(vfile)
}
