% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmrseqFit.R
\name{vmrseqFit}
\alias{vmrseqFit}
\title{Construct candidate regions and detect variably methylated regions.}
\usage{
vmrseqFit(
  gr,
  alpha = 0.05,
  maxGap = 2000,
  stage1only = FALSE,
  minNumCR = 5,
  minNumVMR = 5,
  gradient = TRUE,
  tp = NULL,
  control = vmrseqOptimControl(),
  verbose = TRUE,
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{gr}{\code{GRanges} object output by \code{vmrseq::vmrseqSmooth},
containing genomic coordinates (chr, start, end) and summarized information
(meth, total, var) of CpG sites in the input dataset.}

\item{alpha}{positive scalar value between 0 and 1 that represents the
designated significance level for determining variance threshold of candidate
regions construction. The variance threshold is determined by taking 1-alpha
quantile value of an approximate null distribution of variance simulated
from the beta priors of emission probability in the hidden Markov model.
Default value of alpha is 0.05.}

\item{maxGap}{integer value representing maximum number of base pairs in
between neighboring CpGs to be included in the same VMR. Default value is
2000 bp.}

\item{stage1only}{boolean value indicating whether the algorithm should run
stage 1 of vmrseq (the construction of candidate regions) only. If set to TRUE,
the function will output only the candidate regions. Default is FALSE.}

\item{minNumCR}{positive integer value representing the minimum number of
CpG sites within a candidate region. Default value is 5.}

\item{minNumVMR}{positive integer value representing the minimum number of
CpG sites within a variably methylated region. Default value is 5.}

\item{gradient}{logical value indicating whether exponentiated gradient
descent shall be applied to update prevalence parameter. Default is TRUE. If
set as FALSE, initial values (i.e., value of \code{inits} arguments in
\code{vmrsqe::vmrseqOptimControl}, can be set up in the \code{control}
argument of this function) are used as prevalence parameter for decoding
hidden states.}

\item{tp}{a `transitProbs-class` object that contains the transition
probability distribution used for HMM optimization. Default value is
transition probability \code{vmrseq:::tp0} built in the package that was
previously trained on mouse brain cells. See manuscript for training
procedure and data source.}

\item{control}{list of miscellaneous parameters used to control optimization
of the HMM model. Default is output of \code{vmrseq::vmrseqOptimControl()}.
Can be changed by tweaking arguments in function \code{vmrseq::vmrseqOptimControl()}.}

\item{verbose}{logical value that indicates whether progress messages
should be printed to stdout. Defaults value is TRUE.}

\item{BPPARAM}{a \code{BiocParallelParam} object to specify the parallel
backend. The default option is \code{BiocParallel::bpparam()} which will
automatically creates a cluster appropriate for the operating system.}
}
\value{
The results object is a list of 6 elements that contains the following information:
1. `gr`: The `Granges` object that has been input to `vmrseqFit` with two added metadata columns:
    + `cr_index` = Index in reference to rows of `cr.ranges`, denoting row number of the candidate region to which the CpG site belongs.
    + `vmr_index` = Index in reference to rows of `vmr.ranges`, denoting row number of the variably methylated region to which the CpG site belongs.
2. `vmr.ranges`: A `Granges` object with the coordinates of each detected variably methylated region (each row is a VMR), with metadata columns:
    + `num_cpg` = Number of observed CpG sites in the VMR.
    + `start_ind` = Index of the starting CpG sites in reference to rows of `gr`.
    + `end_ind` = Index of the ending CpG sites in reference to rows of `gr`.
    + `pi` = Prevalence of the methylated grouping (see manuscript for details)
    + `loglik_diff` = Difference in log-likelihood of two-grouping and one-grouping HMM fitted to the VMR; can be used to rank the VMRs.
3. `cr.ranges`: A `Granges` object with the coordinates of each candidate region (each row is a candidate region), with metadata column:
    + `num_cpg` = Number of observed CpG sites in the candidate region.
4. `alpha`: Designated significance level (default 0.05, can be changed by user with function argument). It is used for determining the threshold on variance used for constructing candidate. The threshold is computed by taking the (1-alpha) quantile of an approximate null distribution of variance (see manuscript for details).
5. `var_cutoff`: Variance cutoff computed from `alpha`.
6. `bb_params`: Beta-binomial parameter used in emission probability of the HMM model; they are determined by the magnitude of the input dataset (see manuscript for details).
}
\description{
Construct candidate regions (CRs) by taking groups of consecutive loci that exceed
threshold on the variance of smoothed relative methylation levels and detect
variably methylated regions (VMRs) by optimizing a hidden Markov model (HMM).
}
\examples{
# load example data
data(toy.gr)
# run vmrseqFit
toy.results <- vmrseqFit(toy.gr)
toy.results

}
