% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genesetNetworks.R
\name{computeMsigOverlap}
\alias{computeMsigOverlap}
\title{Compute gene set overlap}
\usage{
computeMsigOverlap(
  msigGsc1,
  msigGsc2 = NULL,
  thresh = 0.25,
  measure = c("ari", "jaccard", "ovlapcoef")
)
}
\arguments{
\item{msigGsc1}{a GeneSetCollection object.}

\item{msigGsc2}{a GeneSetCollection object or NULL if pairwise overlaps are
to be computed.}

\item{thresh}{a numeric, specifying the threshold to discard pairs of gene
sets.}

\item{measure}{a character, specifying the similarity measure to use: \code{ari}
for the Adjusted Rand Index, \code{jaccard} for the Jaccard Index and
\code{ovlapcoef} for the Overlap Coefficient.}
}
\value{
a data.frame, containing the overlap structure of gene sets
represented as a network in the simple interaction format (SIF).
}
\description{
Compute overlap between gene sets from a GeneSetCollection using the Jaccard
index or the overlap coefficient. These values can then be used to compute a
network of gene set overlaps.
}
\examples{
data(hgsc)
ovlap <- computeMsigOverlap(hgsc)

}
