% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signatureDistance.r
\name{viperSimilarity}
\alias{viperSimilarity}
\title{VIPER similarity}
\usage{
viperSimilarity(x, nn = NULL, ws = c(4, 2), method = c("two.sided",
  "greater", "less"))
}
\arguments{
\item{x}{Numeric matrix containing the VIPER results with samples in columns and regulators in rows}

\item{nn}{Optional number of top regulators to consider for computing the similarity}

\item{ws}{Number indicating the weighting exponent for the signature, or vector of 2 numbers indicating the inflection point and the value corresponding to a weighting score of .1 for a sigmoid transformation, only used if \code{nn} is ommited}

\item{method}{Character string indicating whether the most active (greater), less active (less) or both tails (two.sided) of the signature should be used for computing the similarity}
}
\value{
signatureDistance object
}
\description{
If ws is a single number, weighting is performed using an exponential function. If ws is a 2 numbers vector, weighting is performed with a symmetric sigmoid function using the first element as inflection point and the second as trend.
}
\details{
This function computes the similarity between VIPER signatures
}
\examples{
data(bcellViper, package="bcellViper")
dd <- viperSimilarity(exprs(dset))
dd[1:5, 1:5]
scale(dd)[1:5, 1:5]
as.matrix(as.dist(dd))[1:5, 1:5]
}
