% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viper.r
\docType{methods}
\name{viperSignature}
\alias{viperSignature}
\alias{viperSignature,ExpressionSet-method}
\alias{viperSignature,matrix-method}
\title{Generic S4 method for signature and sample-permutation null model for VIPER}
\usage{
viperSignature(eset, ...)

\S4method{viperSignature}{ExpressionSet}(eset, pheno, refgroup,
  method = c("zscore", "ttest", "mean"), per = 100, bootstrap = TRUE,
  seed = 1, cores = 1, verbose = TRUE)

\S4method{viperSignature}{matrix}(eset, ref, method = c("zscore",
  "ttest", "mean"), per = 100, bootstrap = TRUE, seed = 1,
  cores = 1, verbose = TRUE)
}
\arguments{
\item{eset}{ExpressionSet object or numeric matrix containing the test dataset, with genes in rows and samples in columns}

\item{...}{Additional parameters added to keep compatibility}

\item{pheno}{Character string indicating the phenotype data to use}

\item{refgroup}{Vector of character string indicatig the category of \code{pheno} to use as reference group}

\item{method}{Character string indicating how to compute the signature and null model, either ttest, zscore or mean}

\item{per}{Integer indicating the number of sample permutations}

\item{bootstrap}{Logical, whether null model should be estimated with bootstrap. In this case, only reference samples are used.}

\item{seed}{Integer indicating the seed for the random sample generation. The system default is used when set to zero}

\item{cores}{Integer indicating the number of cores to use (only 1 in Windows-based systems)}

\item{verbose}{Logical, whether progression messages should be printed in the terminal}

\item{ref}{Numeric matrix containing the reference samples (columns) and genes in rows}
}
\value{
viperSignature S3 object containing the signature and null model
}
\description{
This function generates a viperSignature object from a test dataset based on a set of samples to use as reference
}
\examples{
data(bcellViper, package="bcellViper")
ss <- viperSignature(dset, "description", c("N", "CB", "CC"), per=100) # Only 100 permutations to reduce computation time, but it is recommended to perform at least 1000 permutations
res <- viper(ss, regulon)
dim(exprs(dset))
exprs(dset)[1:5, 1:5]
regulon
dim(res)
exprs(res)[1:5, 1:5]
data(bcellViper, package="bcellViper")
d1 <- exprs(dset)
pos <- pData(dset)[["description"]] \%in\% c("N", "CB", "CC")
ss <- viperSignature(d1[, !pos], d1[, pos], per=100) # Only 100 permutations to reduce computation time, but it is recommended to perform at least 1000 permutations
res <- viper(ss, regulon)
dim(d1)
d1[1:5, 1:5]
regulon
dim(res)
res[1:5, 1:5]
}
