% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viper.r
\name{viper}
\alias{viper}
\title{VIPER}
\usage{
viper(eset, regulon, dnull = NULL, pleiotropy = FALSE, nes = TRUE,
  method = c("none", "scale", "rank", "mad", "ttest"), bootstraps = 0,
  minsize = 25, adaptive.size = FALSE, eset.filter = TRUE,
  mvws = 1, pleiotropyArgs = list(regulators = 0.05, shadow = 0.05,
  targets = 10, penalty = 20, method = "adaptive"), cores = 1,
  verbose = TRUE)
}
\arguments{
\item{eset}{ExpressionSet object or Numeric matrix containing the expression data or gene expression signatures, with samples in columns and genes in rows}

\item{regulon}{Object of class regulon or list of objects of class regulon for metaVIPER analysis}

\item{dnull}{Numeric matrix for the null model, usually generated by \code{nullTtest}}

\item{pleiotropy}{Logical, whether correction for pleiotropic regulation should be performed}

\item{nes}{Logical, whether the enrichment score reported should be normalized}

\item{method}{Character string indicating the method for computing the single samples signature, either scale, rank, mad, ttest or none}

\item{bootstraps}{Integer indicating the number of bootstraps iterations to perform. Only the scale method is implemented with bootstraps.}

\item{minsize}{Integer indicating the minimum number of targets allowed per regulon}

\item{adaptive.size}{Logical, whether the weighting scores should be taken into account for computing the regulon size}

\item{eset.filter}{Logical, whether the dataset should be limited only to the genes represented in the interactome
#' @param mvws Number or vector indicating either the exponent score for the metaViper weights, or the inflection point and trend for the sigmoid function describing the weights in metaViper}

\item{pleiotropyArgs}{list of 5 numbers for the pleotropy correction indicating: regulators p-value threshold, pleiotropic interaction p-value threshold, minimum number of targets in the overlap between pleiotropic regulators, penalty for the pleiotropic interactions and the method for computing the pleiotropy, either absolute or adaptive}

\item{cores}{Integer indicating the number of cores to use (only 1 in Windows-based systems)}

\item{verbose}{Logical, whether progression messages should be printed in the terminal}
}
\value{
A matrix of inferred activity for each regulator gene in the network across all samples
}
\description{
This function performs Virtual Inference of Protein-activity by Enriched Regulon analysis
}
\examples{
data(bcellViper, package="bcellViper")
d1 <- exprs(dset)
res <- viper(d1, regulon)
dim(d1)
d1[1:5, 1:5]
regulon
dim(res)
res[1:5, 1:5]
}
\seealso{
\code{\link{msviper}}
}
