% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.r
\docType{methods}
\name{rowTtest}
\alias{rowTtest}
\alias{rowTtest,matrix-method}
\alias{rowTtest,ExpressionSet-method}
\title{Student's t-test for rows}
\usage{
rowTtest(x, ...)

\S4method{rowTtest}{matrix}(x, y = NULL, mu = 0,
  alternative = "two.sided")

\S4method{rowTtest}{ExpressionSet}(x, pheno, group1, group2 = NULL,
  mu = 0, alternative = "two.sided")
}
\arguments{
\item{x}{ExpressionSet object or Numerical matrix containing the test samples}

\item{...}{Additional parameters added to keep compatibility}

\item{y}{Optional numerical matrix containing the reference samples. If ommited \code{x} will be tested against mean = \code{mu}}

\item{mu}{Number indicating the alternative hypothesis when \code{y} is ommited}

\item{alternative}{Character string indicating the tail for the test, either two.sided, greater or lower}

\item{pheno}{Character string indicating the phenotype data to use}

\item{group1}{Vector of character strings indicating the category from phenotype \code{pheno} to use as test group}

\item{group2}{Vector of character strings indicating the category from phenotype \code{pheno} to use as control group}
}
\value{
List of Student-t-statistic (\code{statistic}) and p-values (\code{p.value})
}
\description{
This function performs a Student's t-test on each row of a matrix
}
\examples{
data(bcellViper, package="bcellViper")
d1 <- exprs(dset)
res <- rowTtest(d1[, 1:10], d1[, 11:20])
res$statistic[1:5, ]
res$p.value[1:5, ]
data(bcellViper, package="bcellViper")
res <- rowTtest(dset, "description", "CB", "N")
res$statistic[1:5, ]
res$p.value[1:5, ]
}
