% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msviper.r
\name{msviperCombinatorial}
\alias{msviperCombinatorial}
\title{msviper combinatorial analysis}
\usage{
msviperCombinatorial(mobj, regulators = 100, nullmodel = NULL,
  minsize = NULL, adaptive.size = NULL, level = 10, cores = 1,
  processAll = FALSE, verbose = TRUE)
}
\arguments{
\item{mobj}{msviper object generated by \code{msviper} function}

\item{regulators}{Either a number between 0 and 1 indicating the p-value cutoff for individual TFs to be included in the combinations analysis; (>1) indicating the number of top TFs to be included in the combinations analysis; or a vector of character strings indicating the TF IDs to be included in the analysis}

\item{nullmodel}{Matrix of genes by permutations containing the NULL model signatures. Taken from \code{mobj} by default}

\item{minsize}{Number indicating the minimum allowed size for the regulons, taken from \code{mobj} by default}

\item{adaptive.size}{Logical, whether the weight (likelihood) should be used for computing the size, taken from \code{mobj} by default}

\item{level}{Integer, maximum level of combinatorial regulation}

\item{cores}{Integer indicating the number of cores to use (only 1 in Windows-based systems)}

\item{processAll}{Logical, whether all pairs, even if not significant, should be processed for synergy}

\item{verbose}{Logical, whether progression messages should be printed in the terminal}
}
\value{
A msviper object
}
\description{
This function performs combinatorial analysis for msviper objects
}
\examples{
data(bcellViper, package="bcellViper")
sig <- rowTtest(dset, "description", c("CB", "CC"), "N")$statistic
dnull <- ttestNull(dset, "description", c("CB", "CC"), "N", per=100) # Only 100 permutations to reduce computation time, but it is recommended to perform at least 1000 permutations
mra <- msviper(sig, regulon, dnull)
mra <- msviperCombinatorial(mra, 20)
plot(mra, cex=.7)
}
\seealso{
\code{\link{msviper}}
}
