% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.r
\name{msviperAnnot}
\alias{msviperAnnot}
\title{msVIPER annotation change}
\usage{
msviperAnnot(mobj, annot, complete = TRUE)
}
\arguments{
\item{mobj}{msviper object generated by \code{msviper} function}

\item{annot}{Vector os character strings containing the gene names and gene identifiers as vector names attribute}

\item{complete}{Logical, whether the signature and target names should be also transformed}
}
\value{
msviper object with updated annotations
}
\description{
This function changes the annotation of genes in msviper objects
}
\examples{
data(bcellViper, package="bcellViper")
sig <- rowTtest(dset, "description", "CB", "N")$statistic
mra <- msviper(sig, regulon)
tmp <- unique(c(names(mra$regulon), rownames(mra$signature)))
annot <- 1:length(tmp)
names(annot) <- tmp
plot(mra, cex=.7)
mra <- msviperAnnot(mra, annot)
plot(mra, cex=.7)
}
\seealso{
\code{\link{msviper}}
}
