% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpt.r
\name{approxk2d}
\alias{approxk2d}
\title{approxk2d}
\usage{
approxk2d(x, gridsize = 128, pos = x)
}
\arguments{
\item{x}{Matrix of x and y points}

\item{gridsize}{number or vector indicating the size of the greed where to estimate the density}

\item{pos}{Matrix of coordinates to evaluate the density}
}
\value{
Vector of density estimates
}
\description{
This function uses a gaussian kernel to estimate the joint density distribution at the specified points
}
\examples{
x <- rnorm(500)
y <- x+rnorm(500)
kde2 <- approxk2d(cbind(x, y))
plot(x, y, pch=20, col=hsv(0, kde2/max(kde2), 1))
}
