% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vsFourWay.R
\name{vsFourWay}
\alias{vsFourWay}
\title{Four-Way plot for comparison of log fold changes in a multiple factor
RNA-seq experiment from different analytical objects}
\usage{
vsFourWay(
  x,
  y,
  control,
  data,
  d.factor = NULL,
  type = c("cuffdiff", "deseq", "edger"),
  padj = 0.05,
  x.lim = NULL,
  y.lim = NULL,
  lfc = NULL,
  legend = TRUE,
  title = TRUE,
  grid = TRUE,
  highlight = NULL,
  data.return = FALSE,
  xaxis.text.size = 10,
  yaxis.text.size = 10,
  xaxis.title.size = 10,
  yaxis.title.size = 10,
  main.title.size = 15,
  legend.text.size = 9
)
}
\arguments{
\item{x}{treatment \code{x} for comparison (\eqn{log_{2}}(x/control)). This
will be a factor level in your data.}

\item{y}{treatment \code{y} for comparison (\eqn{log_{2}}(y/control)). This
will be a factor level in your data.}

\item{control}{\code{control} treatment for comparisons of the x and y axes.
This will be a factor level in your data.}

\item{data}{output generated from calling the main routines of either
\code{cuffdiff}, \code{DESeq2}, or \code{edgeR} analyses. For
\code{cuffdiff}, this will be a \code{*_exp.diff} file. For \code{DESeq2},
this will be a generated object of class \code{DESeqDataSet}. For
\code{edgeR}, this will be a generated object of class \code{DGEList}.}

\item{d.factor}{a specified factor; for use with \code{DESeq2} objects only.
This input equates to the first parameter for the contrast argument when
invoking the \code{results()} function in \code{DESeq2}. Defaults to
\code{NULL}.}

\item{type}{an analysis classifier to tell the function how to process the
data. Must be either \code{cuffdiff}, \code{deseq}, or \code{edger}.
\code{cuffdiff} must be used with \code{cuffdiff} data; \code{deseq} must
be used for \code{DESeq2} output; \code{edgeR} must be used with
\code{edgeR} data. See the \code{data} parameter for further details.}

\item{padj}{a user defined adjusted \eqn{p}-value cutoff point.
Defaults to \code{0.05}.}

\item{x.lim}{set manual limits (boundaries) to the x axis. Defaults to
\code{NULL}.}

\item{y.lim}{set manual limits (boundaries) to the y axis. Defaults to
\code{NULL}.}

\item{lfc}{log fold change level for setting conditonals. If no user input
is added (\code{NULL}), value defaults to \code{1}.}

\item{legend}{display legend of plot. Logical; defaults to \code{TRUE}.
If set to \code{FALSE}, no legend will display in plot.}

\item{title}{display the main title of plot. Logical; defaults to
\code{TRUE}. If set to \code{FALSE}, no title will display in plot.}

\item{grid}{display major and minor axis lines. Logical; defaults to
\code{TRUE}. If set to \code{FALSE}, no axis lines will display in plot.}

\item{highlight}{character string of IDs that will be highlighted. Set to
\code{NULL} if you do not want highlighted data.}

\item{data.return}{returns data output of plot. Logical; defaults to
\code{FALSE}. If set to \code{TRUE}, a data frame will also be called.
Assign to object for reproduction and saving of data frame. See final
example for further details.}

\item{xaxis.text.size}{change the font size of the \code{x}-axis text. 
Defaults to \code{10}.}

\item{yaxis.text.size}{change the font size of the \code{y}-axis text. 
Defaults to \code{10}.}

\item{xaxis.title.size}{change the font size of the \code{x}-axis title 
text. Defaults to \code{10}.}

\item{yaxis.title.size}{change the font size of the \code{y}-axis title 
text. Defaults to \code{10}.}

\item{main.title.size}{change the font size of the plot title text. 
Defaults to \code{15}.}

\item{legend.text.size}{change the font size of the legend body text.
Defaults to \code{9}.}
}
\value{
An object created by \code{ggplot}
}
\description{
This function allows you to extract necessary results-based data from a
DESeq object class to create a four-way plot to compare log fold changes
in various treatments using ggplot2 aesthetics.
}
\details{
This function allows the user to extract various elements from a different
analytical object class which in turn, creates a temporary data frame to
plot the necessary ggplot aesthetics. In order for this function to work,
RNA seq experiments must have multiple factors (i.e. two treatments and a
control) and levels including treatments and controls. By having the
recommended criteria, this function will extract the necessary data
dependent on the analysis performed. Data points with "extreme" values that
exceed the default viewing frame of the plot will change character classes
(i.e. points of interest a substantially large log fold change).
}
\examples{
# Cuffdiff example
data("df.cuff")
vsFourWay(
     x = "hESC", y = "iPS", control = "Fibroblasts", data = df.cuff,
     d.factor = NULL, type = "cuffdiff", padj = 0.05, x.lim = NULL,
     y.lim = NULL, lfc = 2, title = TRUE, grid = TRUE,
     data.return = FALSE
)

# DESeq2 example
data("df.deseq")
vsFourWay(
     x = "treated_paired.end", y = "untreated_paired.end",
     control = "untreated_single.read", data = df.deseq,
     d.factor = "condition", type = "deseq", padj = 0.05,
     x.lim = NULL, y.lim = NULL, lfc = 2, title = TRUE, grid = TRUE,
     data.return = FALSE
)

# edgeR example
data("df.edger")
require(edgeR)
vsFourWay(
     x = "WM", y = "WW", control = "MM", data = df.edger,
     d.factor = NULL, type = "edger", padj = 0.05, x.lim = NULL,
     y.lim = NULL, lfc = 2, title = TRUE, grid = TRUE,
     data.return = FALSE
)

# Highlight IDs
data("df.edger")
require(edgeR)
hl <- c(
    "ID_639",
    "ID_518",
    "ID_602",
    "ID_449",
    "ID_076"
)
vsFourWay(
    x = "WM", y = "WW", control = "MM", data = df.edger,
    d.factor = NULL, type = "edger", padj = 0.05, x.lim = NULL,
    y.lim = NULL, lfc = 2, title = TRUE, grid = TRUE,
    data.return = FALSE, highlight = hl
)

# Extract data frame from visualization
data("df.cuff")
tmp <- vsFourWay(
     x = "WM", y = "WW", control = "MM", data = df.edger,
     d.factor = NULL, type = "edger", padj = 0.05,
     x.lim = NULL, y.lim = NULL, lfc = 2, title = TRUE,
     grid = TRUE, data.return = TRUE
)
df_four <- tmp[[1]] ## or use tmp$data
head(df_four)

# Show plot from object (see prior example for more details)
tmp[[2]] ## or use tmp$plot
}
\author{
Brandon Monier, \email{brandon.monier@sdstate.edu}
}
