% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{reduceDimensions}
\alias{reduceDimensions}
\title{Reduce dimension using Principal Components Analysis via \code{svds} from \code{RSpectra}}
\usage{
reduceDimensions(
  matnorm,
  center = TRUE,
  scale = TRUE,
  max.ods.genes = 2000,
  nPCs = 50,
  verbose = TRUE,
  plot = FALSE,
  details = FALSE
)
}
\arguments{
\item{matnorm}{matrix on which to perform PCA}

\item{center}{logical to mean center gene expression before PCA, default = TRUE}

\item{scale}{logical to scale gene expression variance before PCA, default = TRUE}

\item{max.ods.genes}{number of most highly expressed overdispersed genes to include, default = 2000}

\item{nPCs}{number of principal components to reduce to return, default = 50}

\item{verbose}{logical for verbosity setting, default = TRUE}

\item{plot}{plot singular values vs number of components}

\item{details}{logical to return pca object, default = FALSE}
}
\value{
matrix of cell scores in nPCs components
}
\description{
Reduce dimension using Principal Components Analysis via \code{svds} from \code{RSpectra}
}
\examples{
data(vel)
curr <- vel$current

curr.norm <- normalizeDepth(curr)
curr.norm <- log10(curr.norm+1)
reduceDimensions(curr.norm, nPCs=3)


}
