% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcovSqrt.R
\docType{methods}
\name{vcovSqrt}
\alias{vcovSqrt}
\alias{vcovSqrt,MArrayLM-method}
\alias{mvTest,MArrayLM-method}
\alias{vcovSqrt,MArrayLM2-method}
\alias{mvTest,MArrayLM2-method}
\title{Sqrt of co-variance matrix for \code{dream()} fit}
\usage{
vcovSqrt(object, vobj, coef, approx = TRUE)

\S4method{vcovSqrt}{MArrayLM}(object, vobj, coef, approx = TRUE)

\S4method{vcovSqrt}{MArrayLM2}(object, vobj, coef, approx = TRUE)
}
\arguments{
\item{object}{\code{MArrayLM} object return by \code{lmFit()} or \code{dream()}}

\item{vobj}{\code{EList} object returned by \code{voom()}}

\item{coef}{name of coefficient to be extracted}

\item{approx}{use fast approximation}
}
\value{
Computes factor of covariance matrix so that \code{vcov(object)} is the same as \code{crossprod(vcovSqrt(object))}
}
\description{
Define generic \code{vcovSqrt()} for result of \code{lmFit()} and \code{dream()}
}
\examples{
# load simulated data:
# geneExpr: matrix of *normalized* gene expression values
# info: information/metadata about each sample
data(varPartData)

form <- ~Batch

fit <- dream(geneExpr[1:2, ], form, info)
fit <- eBayes(fit)

# Compute covariance directly
Sigma <- vcov(fit, geneExpr[1:2, ])

# Compute factor of covariance
S <- crossprod(vcovSqrt(fit, geneExpr[1:2, ]))

}
