% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_logo.R
\name{view_logo}
\alias{view_logo}
\title{Plot logos from numeric matrices.}
\usage{
view_logo(x, fontDF = NULL, fill = "black", colour.scheme = NULL,
  min.height = 0.01, x.spacer = 0.04, y.spacer = 0.01,
  sort.positions = FALSE, sort.positions.decreasing = TRUE,
  fit.to.height = NULL, flip.neg = FALSE)
}
\arguments{
\item{x}{A numeric matrix with row names. The row names can be a mix of
different character lengths.}

\item{fontDF}{\code{data.frame} or \code{DataFrame} Polygon data for letters used
for plotting, as generated by the \code{createPolygons()} function from the
\code{gglogo} package. See the \code{fontDFroboto} data object (which is used
by default when \code{fontDF = NULL}). See \code{Examples} for how to generate
your own font set. Expected columns: \code{x}, \code{y}, \code{order}, \code{group};
additional columns will be ignored.}

\item{fill}{\code{character} A single colour to fill all letters with. Ignored
if \code{colour.scheme} is provided.}

\item{colour.scheme}{\code{character} A named character vector of colour names.
Provide colours for individual letters, even if the row names are made
up of multiple characters.}

\item{min.height}{\code{numeric(1)} Minimum height for a letter to be plotted.
The number is taken as the fraction of the total height of the plot.
The default value is to not show letters which take up 1\% or less of the
vertical space. For smaller figures it is recommended to increase this
value, and vice versa for larger figures.}

\item{x.spacer}{\code{numeric(1)} Add horizontal spacing between letters. The
number is taken as the fraction of the width of an individual position.
Increasing this value is recommended for letters made up of multiple
characters.}

\item{y.spacer}{\code{numeric(1)} Add vertical spacing between letters. The
number is taken as the fraction nof the total height of the plot.}

\item{sort.positions}{\code{logical(1)} Sort letters vertically per position
by height.}

\item{sort.positions.decreasing}{\code{logical(1)} Sort in decreasing or
increasing order based on letter height.}

\item{fit.to.height}{\code{numeric(1)} Normalize the per position height to
this value. If \code{NULL}, no normalization is applied. Note that this
parameter is ignored if \code{use.type = c("PWM", "ICM")}.}

\item{flip.neg}{\code{logical(1)} Flip letters with negative heights.}
}
\value{
A \code{ggplot} object. If you wish to plot the data yourself from
polygon paths, access them using \verb{$data} on the output object. The
theme \code{theme_void()} is applied to the object; apply your own theme
or adjust specific plot parameters with \code{theme()} to change this.
}
\description{
This function provides the plotting capabilities of \code{\link[=view_motifs]{view_motifs()}} without
requiring \code{universalmotif}-class objects. Instead, it takes a numeric matrix
with row names as input. Additionally, columns can be of any height and
letters can be a mix of different character lengths.
}
\examples{
## Feel free to mix and match row name character lengths and column sums.
data(examplemotif)
toplot <- examplemotif["motif"]
toplot[4] <- 2
toplot[20] <- -0.5
rownames(toplot)[1] <- "AA"
view_logo(toplot)

}
\seealso{
\code{\link[=view_motifs]{view_motifs()}}
}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
