% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/universalmotif-class.R,
%   R/universalmotif-methods.R
\docType{class}
\name{universalmotif-class}
\alias{universalmotif-class}
\alias{universalmotif}
\alias{[,universalmotif-method}
\alias{[<-,universalmotif-method}
\alias{initialize,universalmotif-method}
\alias{show,universalmotif-method}
\alias{as.data.frame,universalmotif-method}
\alias{subset,universalmotif-method}
\alias{normalize,universalmotif-method}
\alias{rowMeans,universalmotif-method}
\alias{colMeans,universalmotif-method}
\alias{colSums,universalmotif-method}
\alias{rowSums,universalmotif-method}
\alias{nrow,universalmotif-method}
\alias{ncol,universalmotif-method}
\alias{colnames,universalmotif-method}
\alias{rownames,universalmotif-method}
\alias{cbind,universalmotif-method}
\title{universalmotif: Motif class.}
\usage{
\S4method{[}{universalmotif}(x, i)

\S4method{[}{universalmotif}(x, i) <- value

\S4method{initialize}{universalmotif}(.Object, name, altname, family, organism,
  motif, alphabet = "DNA", type, icscore, nsites, pseudocount = 1, bkg,
  bkgsites, consensus, strand = "+-", pval, qval, eval, multifreq, extrainfo,
  gapinfo)

\S4method{show}{universalmotif}(object)

\S4method{as.data.frame}{universalmotif}(x)

\S4method{subset}{universalmotif}(x, select)

\S4method{normalize}{universalmotif}(object)

\S4method{rowMeans}{universalmotif}(x)

\S4method{colMeans}{universalmotif}(x)

\S4method{colSums}{universalmotif}(x)

\S4method{rowSums}{universalmotif}(x)

\S4method{nrow}{universalmotif}(x)

\S4method{ncol}{universalmotif}(x)

\S4method{colnames}{universalmotif}(x)

\S4method{rownames}{universalmotif}(x)

\S4method{cbind}{universalmotif}(..., deparse.level = 0)
}
\arguments{
\item{x}{\linkS4class{universalmotif} Motif.}

\item{i}{\code{character} Slot.}

\item{value}{Object to replace slot with.}

\item{.Object}{\linkS4class{universalmotif} Final motif.}

\item{name}{\code{character(1)} Motif name.}

\item{altname}{\code{character(1)} Alternate motif name.}

\item{family}{\code{character(1)} Transcription factor family.}

\item{organism}{\code{character(1)} Species of origin.}

\item{motif}{\code{matrix} Each column represents a position in the motif.}

\item{alphabet}{\code{character(1)} One of \code{c('DNA', 'RNA', 'AA')},
or a combined string representing the letters.}

\item{type}{\code{character(1)} One of \code{c('PCM', 'PPM', 'PWM', 'ICM')}.}

\item{icscore}{\code{numeric(1)} Total information content. Automatically generated.}

\item{nsites}{\code{numeric(1)} Number of sites the motif was constructed from.}

\item{pseudocount}{\code{numeric(1)} Correction to be applied to prevent \code{-Inf}
from appearing in PWM matrices.}

\item{bkg}{\code{numeric} A vector of probabilities, each between 0 and 1. If
higher order backgrounds are provided, then the elements of the vector
must be named.}

\item{bkgsites}{\code{numeric(1)} Total number of sites used to find the motif.}

\item{consensus}{\code{character(1)} Consensus string. Automatically generated for
'DNA', 'RNA', and 'AA' alphabets.}

\item{strand}{\code{character(1)} Whether the motif is specific to a certain strand.}

\item{pval}{\code{numeric(1)} P-value associated with motif.}

\item{qval}{\code{numeric(1)} Adjusted P-value associated with motif.}

\item{eval}{\code{numeric(1)} E-value associated with motif.}

\item{multifreq}{\code{list} See \code{\link[=add_multifreq]{add_multifreq()}}.}

\item{extrainfo}{\code{character} Any other extra information, represented as
a named character vector.}

\item{gapinfo}{\code{universalmotif_gapped(1)} Gapped motif information.}

\item{object}{\linkS4class{universalmotif} Motif.}

\item{select}{\code{numeric} Columns to keep.}

\item{...}{\linkS4class{universalmotif} Motifs.}

\item{deparse.level}{Unused.}
}
\value{
A motif object of class \linkS4class{universalmotif}.
}
\description{
Container for motif objects. See \code{\link[=create_motif]{create_motif()}} for creating
motifs as well as a more detailed description of the slots. For a
brief description of available methods, see \code{examples}.
}
\section{Slots}{

\describe{
\item{\code{name}}{\code{character(1)}}

\item{\code{altname}}{\code{character(1)}}

\item{\code{family}}{\code{character(1)}}

\item{\code{organism}}{\code{character(1)}}

\item{\code{motif}}{\code{matrix}}

\item{\code{alphabet}}{\code{character(1)}}

\item{\code{type}}{\code{character(1)}}

\item{\code{icscore}}{\code{numeric(1)} Generated automatically.}

\item{\code{nsites}}{\code{numeric(1)}}

\item{\code{pseudocount}}{\code{numeric(1)}}

\item{\code{bkg}}{\code{numeric} 0-order probabilities must be provided for all letters.}

\item{\code{bkgsites}}{\code{numeric(1)}}

\item{\code{consensus}}{\code{character} Generated automatically.}

\item{\code{strand}}{\code{character(1)}}

\item{\code{pval}}{\code{numeric(1)}}

\item{\code{qval}}{\code{numeric(1)}}

\item{\code{eval}}{\code{numeric(1)}}

\item{\code{multifreq}}{\code{list}}

\item{\code{extrainfo}}{\code{character}}

\item{\code{gapinfo}}{\code{universalmotif_gapped(1)}}
}}

\examples{
## [
## Access the slots.
motif <- create_motif()
motif["motif"]
# you can also access multiple slots at once, released as a list
motif[c("motif", "name")]

## [<-
## Replace the slots.
motif["name"] <- "new name"
# some slots are protected
# motif["consensus"] <- "AAAA"  # not allowed

## c
## Assemble a list of motifs.
c(motif, motif)

## as.data.frame
## Represent a motif as a data.frame. The actual motif matrix is lost.
## Necessary for `summarise_motifs`.
as.data.frame(motif)

## subset
## Subset a motif matrix by column.
subset(motif, 3:7)  # extract motif core

## normalize
## Apply the pseudocount slot (or `1`, if the slot is set to zero) to the
## motif matrix.
motif2 <- create_motif("AAAAA", nsites = 100, pseudocount = 1)
normalize(motif2)

## rowMeans
## Calculate motif rowMeans.
rowMeans(motif)

## colMeans
## Calculate motif colMeans.
colMeans(motif)

## colSums
## Calculate motif colSums
colSums(motif)

## rowSums
## Calculate motif rowSums.
rowSums(motif)

## nrow
## Count motif rows.
nrow(motif)

## ncol
## Count motif columns.
ncol(motif)

## colnames
## Get motif colnames.
colnames(motif)

## rownames
## Get motif rownames.
rownames(motif)

## cbind
## Bind motifs together to create a new motif.
cbind(motif, motif2)

}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
