% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cisbp.R
\name{read_cisbp}
\alias{read_cisbp}
\title{Import CIS-BP motifs.}
\usage{
read_cisbp(file, skip = 0)
}
\arguments{
\item{file}{\code{character(1)} File name.}

\item{skip}{\code{numeric(1)} If not zero, will skip however many desired lines in the
file before starting to read.}
}
\value{
\code{list} \linkS4class{universalmotif} objects.
}
\description{
Import CIS-BP formatted motifs. See \url{http://cisbp.ccbr.utoronto.ca/index.php}.
Assumed to be DNA motifs.
}
\details{
CIS-BP motifs can be formatted with or without additional header metadata.
Motifs without any header start at instances of the word "Pos", whereas motifs
with a header start at instances of the word "TF".
}
\examples{
cisbp <- read_cisbp(system.file("extdata", "cisbp.txt",
                                package = "universalmotif"))

}
\references{
Weirauch MT, Yang A, Albu M, Cote AG, Montenegro-Montero A, Drewe
P, Najafabadi HS, Lambert SA, Mann I, Cook K, Zheng H, Goity A,
van Bakel H, Lozano JC, Galli M, Lewsey MG, Huang E, Mukherjee T,
Chen X, Reece-Hoyes JS, Govindarajan S, Shaulsky G, Walhout AJ,
Bouget FY, Ratsch G, Larrondo LF, Ecker JR, Hughes TR (2014).
“Determination and inference of eukaryotic transcription factor
sequence specificity.” \emph{Cell}, \strong{158}, 1431-1443.
}
\seealso{
Other read_motifs: 
\code{\link{read_homer}()},
\code{\link{read_jaspar}()},
\code{\link{read_matrix}()},
\code{\link{read_meme}()},
\code{\link{read_motifs}()},
\code{\link{read_transfac}()},
\code{\link{read_uniprobe}()}
}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
\concept{read_motifs}
