% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_motifs.R
\name{filter_motifs}
\alias{filter_motifs}
\title{Filter a list of motifs.}
\usage{
filter_motifs(motifs, name, altname, family, organism, width, alphabet, type,
  icscore, nsites, strand, pval, qval, eval, extrainfo)
}
\arguments{
\item{motifs}{\code{list} See \code{\link[=convert_motifs]{convert_motifs()}} for acceptable
formats.}

\item{name}{\code{character} Keep motifs by names.}

\item{altname}{\code{character} Keep motifs by altnames.}

\item{family}{\code{character} Keep motifs by family.}

\item{organism}{\code{character} Keep motifs by organism.}

\item{width}{\code{numeric(1)} Keep motifs with minimum width.}

\item{alphabet}{\code{character} Keep motifs by alphabet.}

\item{type}{\code{character} Keep motifs by type.}

\item{icscore}{\code{numeric(1)} Keep motifs with minimum total IC.}

\item{nsites}{\code{numeric(1)} Keep motifs with minimum number of target sites.}

\item{strand}{\code{character} Keeps motifs by strand.}

\item{pval}{\code{numeric(1)} Keep motifs by max P-value.}

\item{qval}{\code{numeric(1)} Keep motifs by max Q-value.}

\item{eval}{\code{numeric(1)} Keep motifs by max E-val.}

\item{extrainfo}{\code{character} Named character vector of items that must be
present in motif \code{extrainfo} slots.}
}
\value{
\code{list} Motifs. An attempt will be made to preserve the original
class, see \code{\link[=convert_motifs]{convert_motifs()}} for limitations.
}
\description{
Filter motifs based on the contents of available \linkS4class{universalmotif}
slots. If the input motifs are not of \linkS4class{universalmotif}, then
they will be converted for the duration of the \code{\link[=filter_motifs]{filter_motifs()}} operation.
}
\examples{
## By minimum IC:
jaspar <- read_jaspar(system.file("extdata", "jaspar.txt",
                                  package = "universalmotif"))
jaspar.ic3 <- filter_motifs(jaspar, icscore = 3)

## Starting from version 1.10.0 of the universalmotif package, one
## could instead make use of the universalmotif_df structure:
jaspar.ic3 <- jaspar |> to_df() |> subset(icscore > 3) |> to_list()

## By organism:
\dontrun{
library(MotifDb)
motifs <- convert_motifs(MotifDb)
motifs <- filter_motifs(motifs, organism = c("Athaliana", "Mmusculus"),
                        extrainfo = c("dataSource" = "cisbp_1.02"))
## Or:
motifs <- convert_motifs(MotifDb) |> to_df() |>
  subset(organism \%in\% c("Athaliana", "Mmusculus") &
    dataSource == "cisbp_1.02") |> to_list()
}

}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
