% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_sequences.R
\name{create_sequences}
\alias{create_sequences}
\title{Create random sequences.}
\usage{
create_sequences(alphabet = "DNA", seqnum = 100, seqlen = 100, freqs,
  nthreads = 1, rng.seed = sample.int(10000, 1))
}
\arguments{
\item{alphabet}{\code{character(1)} One of \code{c('DNA', 'RNA', 'AA')}, or a string of
characters to be used as the alphabet.}

\item{seqnum}{\code{numeric(1)} Number of sequences to generate.}

\item{seqlen}{\code{numeric(1)} Length of random sequences.}

\item{freqs}{\code{numeric} A named vector of probabilities. The length of the
vector must be the power of the number of letters in the sequence alphabet.
Probabilities can only be provided for a single size k.}

\item{nthreads}{\code{numeric(1)} Run \code{\link[=create_sequences]{create_sequences()}} in parallel with \code{nthreads}
threads. \code{nthreads = 0} uses all available threads.
Note that no speed up will occur for jobs with \code{seqnum = 1}.}

\item{rng.seed}{\code{numeric(1)} Set random number generator seed. Since sequence
creation can occur simultaneously in multiple threads using C++, it cannot
communicate with the regular \code{R} random number generator state and thus requires
an independent seed. Each individual sequence creation instance is
given the following seed: \code{rng.seed * index}. The default is to pick a random
number as chosen by \code{\link[=sample]{sample()}}, which effectively is making \code{\link[=create_sequences]{create_sequences()}}
dependent on the R RNG state.}
}
\value{
\code{\link{XStringSet}} The returned sequences are \emph{unnamed}.
}
\description{
Generate random sequences from any set of characters, represented as
\code{\link{XStringSet}} objects.
}
\examples{
## Create DNA sequences with slightly increased AT content:
sequences <- create_sequences(freqs = c(A=0.3, C=0.2, G=0.2, T=0.3))
## Create custom sequences:
sequences.QWER <- create_sequences("QWER")
## You can include non-alphabet characters are well, even spaces:
sequences.custom <- create_sequences("!@#$ ")

}
\seealso{
\code{\link[=create_motif]{create_motif()}}, \code{\link[=shuffle_sequences]{shuffle_sequences()}}
}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
