# Contributing to the universalmotif project

Welcome and thank you for considering contributing to the universalmotif project.

Reading and following these guidelines will help us make the contribution process easy and effective for everyone involved. It also communicates that you agree to respect the time of the developers managing and developing these open source projects. In return, we will reciprocate that respect by addressing your issue, assessing changes, and helping you finalize your pull requests.

## Quicklinks

* [Getting Started](#getting-started)
    * [Issues](#issues)
    * [Pull Requests](#pull-requests)
* [Getting Help](#getting-help)

## Getting Started

Contributions are made to this repo via Issues and Pull Requests (PRs). A few general guidelines that cover both:

- Search for existing Issues and PRs before creating your own.
- Bugs and bug fixes can be targeted to either the current Bioconductor release branch or the Bioconductor devel branch / GitHub master branch.
- Due to the structure and rules of the Bioconductor project, older Bioconductor release versions of the universalmotif package cannot be updated and thus will not receive bug fixes. If you encounter a bug in an older release version, please confirm it is still an existing bug in the current release before creating an issue.
- New feature requests and pull requests must be targeted to the GitHub master branch.

### Issues

Issues should be used to report problems with the library, request a new feature, or to discuss potential changes before a PR is created. Please include basic information such as the version of the package you are using and how to reproduce the issue.

### Pull Requests

PRs to our libraries are always welcome and can be a quick way to get your fix or improvement slated for the next release. In general, PRs should:

- Only fix/add the functionality in question **OR** address wide-spread whitespace/style issues, not both.
- Add unit or integration tests for fixed or changed functionality.
- Address a single concern in the least number of changed lines as possible.
- Include documentation and examples.

For changes that address core functionality or would require breaking changes (e.g. a major release), it's best to open an Issue to discuss your proposal first. This is not required but can save time creating and reviewing changes.

In general, we follow the ["fork-and-pull" Git workflow](https://github.com/susam/gitpr)

1. Fork the repository to your own Github account
2. Clone the project to your machine
3. Create a branch locally with a succinct but descriptive name
4. Commit changes to the branch
5. Following any formatting and testing guidelines specific to this repo
6. Push changes to your fork
7. Open a PR in the `bjmt/universalmotif` repository.

## Getting Help

For questions or doubts about the functionality of the universalmotif package, please ask a question on the [Bioconductor support site](https://support.bioconductor.org/new/post/).

