% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uwmwEstimate_Class.R
\docType{class}
\name{uwmwEstimate-class}
\alias{uwmwEstimate-class}
\alias{uwmwEstimate}
\title{The class uwmwEstimate}
\description{
This class represents an estimate object resulting from a call to \code{\link{getEstimate}}. It contains all information about the estimate, including standard errors and confidence intervals if requested. For this class a number of methods is foreseen, including the accessors for the slots. The class is sortable and can be indexed, so you can use this for making custom forest plots using the function \code{\link{forestplot}}.
}
\details{
#' @section Slots:
\describe{
   \item{\code{esttype}:}{object of class \code{"character"}, containing the estimate type. This can be logor for log odds ratio, or for odds ratio, odds, logodds for the log odds or p for the probability.}
   \item{\code{names}:}{object of class \code{"character"}, containing the names of the genes for which the estimates are calculated.}  
   \item{\code{est}:}{object of class \code{"numeric"}, containing the estimates itself.}
   \item{\code{se}:}{object of class \code{"numeric"}, containing the estimates for the standard error, if applicable.}
   \item{\code{ll}:}{object of class \code{"numeric"}, containing the lower limit of the confidence interval.}
   \item{\code{ul}:}{object of class \code{"numeric"}, containing the upper limit of the confidence interval.}
   \item{\code{refest}:}{object of class \code{"numeric"}, containing the estimate for the reference used in the analysis. Note that this only makes sense for log odds, odds and probabilities.}
   \item{\code{refse}:}{object of class \code{"numeric"}, containing the se estimate for the reference if applicable.}
   \item{\code{refll}:}{object of class \code{"numeric"}, containing the lower limit for the reference if applicable.}
   \item{\code{reful}:}{object of class \code{"numeric"}, containing the upper limit for the reference if applicable.}
   \item{\code{type}:}{vector of class \code{"character"}, containing the type of reference used in the original analysis. This can be either "O" or "H" for Overall respectively Housekeeping Expression as reference.} 
   \item{\code{confint}:}{vector of class \code{"numeric"}}, indicating the limit used for the confidence interval. 0.95 represents the 95\% confidence interval.
   \item{\code{housekeeping}:}{object of class \code{"character"}, containing either NULL or the names of the housekeeping genes used in the H version of \code{\link{uWMW}}.}
   \item{\code{groupinfo}:}{character vector of length 2, indicating the groups. This slot is mainly used to show how the probabilistic indices are calculated.} 
}
}
\note{
For this class, \code{\link{show}} and \code{\link{length}} methods are defined. \code{\link{length}} will give you the number of features.
}
\author{
Joris Meys
}
