% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swanderlust.R
\name{sWanderlust}
\alias{sWanderlust}
\title{sWanderlust}
\usage{
sWanderlust(data, data_type = c("linear", "cyclical"),
  SPIN_option = c("STS", "neighborhood"), alpha = 0.2, sigma_width = 1,
  diffusionmap_components = 4, l = 15, k = 15, num_waypoints = 150,
  flock_waypoints = 2, waypoints_seed = 2711)
}
\arguments{
\item{data}{data Input data matrix.}

\item{data_type}{The data type which guides the autoSPIN sorting, including \code{linear}, \code{cyclical}.}

\item{SPIN_option}{SPIN contains two options including \code{STS}(default), \code{neighborhood}.}

\item{alpha}{alpha parameter for autoSPIN, default is 0.2.}

\item{sigma_width}{Sigma width parameter for SPIN, default is 1.}

\item{diffusionmap_components}{Number of components from diffusion map used for wanderlust analysis, default is 4.}

\item{l}{Number of nearest neighbors, default is 15.}

\item{k}{Number of nearest neighbors for repeating graphs, default is 15, should be less than or equal to l.}

\item{num_waypoints}{Number of waypoint used for wanderlust, default is 150.}

\item{flock_waypoints}{The number of times for flocking the waypoints, default is 2.}

\item{waypoints_seed}{The seed for reproducing the results.}
}
\value{
a vector of the sorted oder.
}
\description{
autoSPIN guided wanderlust. Specifically, we use autoSPIN to help find the starting point for wanderlust.
}
\examples{
set.seed(15)
shuffled_iris <- iris[sample(150, 150, replace = FALSE), ]
data <- shuffled_iris[,1:4]
data_label <- shuffled_iris[,5]
wishbone <- sWanderlust(data = data, num_waypoints = 100)
}
\author{
Hao Chen
}

