% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPIN.r
\name{neighborhood_sortingcost}
\alias{neighborhood_sortingcost}
\title{A cost computation function for Neighborhood algorithm}
\usage{
neighborhood_sortingcost(expr = NULL, sigma_width = 1,
  method = c("Euclidean", "Correlation", "eJaccard", "none"))
}
\arguments{
\item{expr}{An expresssion matrix containing n-rows of cells and m-cols of genes.}

\item{sigma_width}{An integer number determining the degree of spread of the gaussian distribution which
is used for computing weight matrix for Neighborhood sorting method.}

\item{method}{A character string indicating the distance function.}
}
\value{
A numeric value of sorting cost.
}
\description{
A cost computation function for Neighborhood algorithm
}
\examples{
set.seed(15)
da <- iris[sample(150, 150, replace = FALSE), ]
d <- da[,1:4]
randomOrdering_cost <- neighborhood_sortingcost(d, method= 'Euclidean')
randomOrdering_cost

da <- iris
d <- da[,1:4]
properOrdering_cost <- neighborhood_sortingcost(d, method= 'Euclidean')
properOrdering_cost
}

