% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPIN.r
\name{STS_sortingcost}
\alias{STS_sortingcost}
\title{A cost computation function for Side-to-Side (STS) algorithm}
\usage{
STS_sortingcost(expr = NULL, method = c("Euclidean", "Correlation",
  "eJaccard", "none"))
}
\arguments{
\item{expr}{An expresssion matrix containing n-rows of cells and m-cols of genes.}

\item{method}{A character string indicating the distance function.}
}
\value{
A numeric value of sorting cost.
}
\description{
A cost computation function for Side-to-Side (STS) algorithm
}
\examples{
set.seed(15)
da <- iris[sample(150, 150, replace = FALSE), ]
d <- da[,1:4]
randomOrdering_cost <- STS_sortingcost(d, method= 'Euclidean')
randomOrdering_cost

da <- iris
d <- da[,1:4]
properOrdering_cost <- STS_sortingcost(d, method= 'Euclidean')
properOrdering_cost
}

