% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPIN.r
\name{SPIN}
\alias{SPIN}
\title{A wrapper function for SPIN sorting method}
\usage{
SPIN(data, sorting_method = c("STS", "neighborhood"), sigma_width = 1)
}
\arguments{
\item{data}{An log2 transformed expresssion matrix containing n-rows of cells and m-cols of genes.}

\item{sorting_method}{A character string indicating the choice of sorting method, i.e. 'STS' (Side-to-Side)
or 'Neighborhood'.}

\item{sigma_width}{An integer number determining the degree of spread of the gaussian distribution which
is used for computing weight matrix for Neighborhood sorting method.}
}
\value{
A data frame containing single column of ordered sample IDs.
}
\description{
A wrapper function for SPIN method  provides a R version of SPIN [Tsafrir et al. 2005].
}
\examples{
set.seed(15)
da <- iris[sample(150, 150, replace = FALSE), ]
rownames(da) <- paste0('spl_',seq(1,nrow(da)))
d <- da[,1:4]
dl <- da[,5,drop=FALSE]
res <- SPIN(data = d)
dl <- dl[match(res$SampleID,rownames(dl)),]
annot <- data.frame(id = seq(1,nrow(res)), label=dl, stringsAsFactors = FALSE)
#ggplot(annot, aes(x=id, y=id, colour = label)) + geom_point() + theme_bw()
}

