% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed_reference.R
\name{inspectDigests}
\alias{inspectDigests}
\title{Inspect digest matches from \code{importData()} imported data}
\usage{
inspectDigests(
  se,
  type = "oarfish",
  prefer = c("txome", "txpdata", "precomputed"),
  fullDigest = FALSE,
  count = FALSE
)
}
\arguments{
\item{se}{the \emph{SummarizedExperiment} output by \code{importData()},
or alternatively just
\code{metadata(se)$quantInfo}, a list of metadata
information from the quantification tool
(assuming \code{annotated} and \code{novel} indices both used)}

\item{type}{what quantifier was used (see \code{\link[tximport:tximport]{tximport::tximport()}})}

\item{prefer}{vector of length up to 3, giving the preferred order of
\emph{tximeta}'s transcript registries to when finding matches, with elements:
\code{txome}: linkedTxome,
\code{txpdata}: linkedTxpData,
\code{precomputed}: the pre-computed digests in tximeta}

\item{fullDigest}{whether to include the full digest string in the output,
in addition to the shortened 6-char version}

\item{count}{whether to count the number of matching transcripts ID to each index
(only possible for those indices that have matching metadata).
Counting requires loading transcript data, either from locally cached databases
or from GTF files.}
}
\value{
a 2-row tibble of the \code{annotated} and \code{novel} index,
their matching information if available
(source, organism, release), for matches,
whether it is a \code{linkedTxome} or a \code{linkedTxpData}
(both `FALSE`` for pre-computed)
and a small 6 character version of the digest itself.
}
\description{
This function takes as input a \emph{SummarizedExperiment} as output by \code{importData()}
and returns a tibble with information about the digest-match status of two
indices (\code{annotated} and \code{novel}), with respect to \emph{tximeta} metadata.
Inspection of index digests can be run iteratively, checking if
the digests used in the mixed reference transcript set
have a match against 1) pre-computed digests representing
standard annotated sets (e.g. GENCODE, Ensembl, etc.)
or 2) digests added by the user to a local registry with
\code{makeLinkedTxome()} (GTF file)
or \code{makeLinkedTxpData} (\emph{GRanges}-based metadata).
Optional columns may be added if specified by
\code{fullDigest=TRUE} (include the full digest) and/or
\code{count=TRUE} (add matching transcript ID counts per index).
Following inspection, one can run \code{updateMetadata()} to automatically update
the transcript metadata using the sources indicated by this function.
}
\examples{

example(importData)
# now we have an `se` created by importData()...
inspectDigests(se)
# can then update the registry via makeLinkedTxome() and re-run inspection

}
