% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncateTxome.R
\name{truncateTxome}
\alias{truncateTxome}
\alias{truncateTxome,TxDb-method}
\title{Truncate Transcriptome}
\usage{
truncateTxome(txdb, maxTxLength = 500, ...)

\S4method{truncateTxome}{TxDb}(txdb, maxTxLength = 500, BPPARAM = bpparam())
}
\arguments{
\item{txdb}{a \code{TxDb} object}

\item{maxTxLength}{the maximum length of transcripts}

\item{...}{additional arguments}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object specifying whether
and how the method should be parallelized.}
}
\value{
a \code{TxDb} object

a \code{TxDb} object
}
\description{
Truncate Transcriptome
}
\examples{
library(TxDb.Scerevisiae.UCSC.sacCer3.sgdGene)

## load annotation
txdb <- TxDb.Scerevisiae.UCSC.sacCer3.sgdGene

## restrict to 'chrI' transcripts
seqlevels(txdb) <- c("chrI")

## last 500 nts per tx
txdb_w500 <- truncateTxome(txdb)
txdb_w500

## last 100 nts per tx
txdb_w100 <- truncateTxome(txdb, maxTxLength=100)
txdb_w100

}
