% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddpcrWell.R
\name{wellClassificationMethod}
\alias{wellClassificationMethod}
\alias{wellClassificationMethod,ddpcrWell-method}
\alias{wellClassificationMethod<-}
\alias{wellClassificationMethod<-,ddpcrWell-method}
\title{Retrieve the classification method.}
\usage{
wellClassificationMethod(theObject)

\S4method{wellClassificationMethod}{ddpcrWell}(theObject)

wellClassificationMethod(theObject, cMethod) <- value

\S4method{wellClassificationMethod}{ddpcrWell}(theObject, cMethod) <- value
}
\arguments{
\item{theObject}{A \code{\link{ddpcrWell}} object.}

\item{cMethod}{If modifying the classification methods, this should be
a vector of existing classification names or numbers.}

\item{value}{A character vector (of the same length as \code{cMethod})
giving a new names for the chosen classification methods.}
}
\value{
The classification method names.
}
\description{
Retrieve the names of the classification methods for
a \code{\link{ddpcrWell}} object.
}
\examples{
## Create a ddpcrWell object with some data and classification.
aWell <- ddpcrWell(well=KRASdata[["E03"]])

## Retrieve the classification method names.
head(wellClassificationMethod(aWell))

## Set a classification method name to something new.
wellClassificationMethod(aWell, cMethod="Cluster") <- "QuantaSoft"

## We check the classification now, showing the amplitudes as well.
wellClassificationMethod(aWell)

}
\seealso{
\code{\link{wellClassification}} for the classification of the
droplets.
}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
