% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddpcrWell.R
\name{wellClassification}
\alias{wellClassification}
\alias{wellClassification,ddpcrWell-method}
\alias{wellClassification<-}
\alias{wellClassification<-,ddpcrWell-method}
\title{Retrieve a classification vector.}
\usage{
wellClassification(theObject, cMethod = NULL, withAmplitudes = FALSE)

\S4method{wellClassification}{ddpcrWell}(theObject, cMethod = NULL, withAmplitudes = FALSE)

wellClassification(theObject, cMethod) <- value

\S4method{wellClassification}{ddpcrWell}(theObject, cMethod) <- value
}
\arguments{
\item{theObject}{A \code{\link{ddpcrWell}} object.}

\item{cMethod}{The names (or column numbers) of the classification to
retrieve. If \code{NULL}, then all of the classifications are obtained.
Defaults to \code{NULL} when retrieving. When setting a classification, this
cannot be \code{NULL}.}

\item{withAmplitudes}{Logical value. If \code{TRUE}, returns a data frame
with the droplet amplitudes and corresponding classifications. If
\code{FALSE}, returns the classification vector only. Defaults to
\code{FALSE}.}

\item{value}{A factor with the same length as the number of droplets in
\code{theObject}, with levels in \code{ddpcr$classesRain}.}
}
\value{
A factor or data frame corresponding to the requested
classification(s).
}
\description{
Retrieve the classification from a \code{\link{ddpcrWell}} object.
}
\examples{
## Take some droplets with a given classification.
amplitudes <- KRASdata[["E03"]][, c("Ch1.Amplitude", "Ch2.Amplitude")]

## Create a ddpcrWell object with the amplitudes only.
aWell <- ddpcrWell(well=amplitudes)

## This has no classification yet.
head(wellClassification(aWell))

## We check the classification now, showing the amplitudes as well.
head(wellClassification(aWell, withAmplitudes=TRUE))

## Now set a sample classification.
wellClassification(aWell, cMethod="Sample") <-
  rep(c("NN", "NP", "PN", "PP"), numDroplets(aWell) / 4)
head(wellClassification(aWell, withAmplitudes=TRUE))

}
\seealso{
\code{\link{wellClassificationMethod}} for the name of the
classification method.
}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
