% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wellNameSort.R
\name{sortWells}
\alias{sortWells}
\title{Return given well names sorted.}
\usage{
sortWells(wellNames, sortByLetter)
}
\arguments{
\item{wellNames}{The well names to sort.}

\item{sortByLetter}{If \code{TRUE}, the resulting list is sorted by the
letter in the well names first, e.g. "A02" comes before "B01". If
\code{FALSE}, the result is sorted by the numeric component of the well
names first, e.g. "B01" comes before "A02". Defaults to \code{FALSE}.}
}
\value{
The well names sorted.
}
\description{
Well names can be sorted according to the leading letter or the trailing
digit.
}
\examples{
## Use the KRASdata dataset as an example.
plate <- ddpcrPlate(wells=KRASdata)
wellNames <- names(plate)

## Sample sorting.
sortWells(wellNames=wellNames, sortByLetter=FALSE)
sortWells(wellNames=wellNames, sortByLetter=TRUE)

}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
