% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdRain.R
\name{sdRain}
\alias{sdRain}
\alias{sdRain,data.frame-method}
\alias{sdRain,ddpcrWell-method}
\alias{sdRain,ddpcrPlate-method}
\title{Add rain to a classification by using a chosen multiple of standard
deviation.}
\usage{
sdRain(droplets, cMethod, errorLevel = 5, ...)

\S4method{sdRain}{data.frame}(droplets, cMethod, errorLevel = 5, fullTable = TRUE)

\S4method{sdRain}{ddpcrWell}(droplets, cMethod, errorLevel = 5)

\S4method{sdRain}{ddpcrPlate}(droplets, cMethod, errorLevel = 5)
}
\arguments{
\item{droplets}{A \code{\link{ddpcrWell}} or \code{\link{ddpcrPlate}}
object, or a droplet data frame including a classification column.}

\item{cMethod}{The name or column number of the classification for which we
want to add rain to.}

\item{errorLevel}{How many multiples of standard deviation from the mean of
each cluster to retain. Can be a list where each item corresponds to a class
name and the multiple for that class. Can also be a numeric vector of length
1, which is equivalent to a list with all the same entries. Defaults to 5.}

\item{...}{Other options depending on the type of \code{droplets}.}

\item{fullTable}{If \code{TRUE}, returns a full data frame of droplets with
an extra column of rainy data; if \code{FALSE}, simply returns a factor
where each entry corresponds to an entry in the original classification
column with added rain. Defaults to \code{FALSE}.}
}
\value{
If \code{droplets} is a data frame, return a data frame or factor
(depending on \code{fullTable}) where droplets with ambiguous
classifications are labelled as "Rain".

If \code{droplets} is a \code{ddpcrWell} object, return
a \code{ddpcrWell} object with a rainy classification.

If \code{droplets} is a \code{ddpcrPlate} object, return
a \code{ddpcrPlate} object with a rainy classifications.
}
\description{
Although we can use various algorithms to classify all droplets
in a ddPCR experiment, there will be some variation between the
classifications. We can perhaps have a relatively high confidence that
droplets near the centres of clusters do indeed belong to that cluster,
whereas we probably have a lower confidence in the classification of those
further away, say, near the 'boundary' of two clusters. We may view these
droplets (or a subset of them) as having an ambiguous class. This function
allows us to only consider droplets classified within a certain distance of
the means of each cluster and label the rest as "Rain".
}
\examples{
## Compare the types of droplets in a single well for the "Cluster" class
## and then with rain.
aWell <- ddpcrWell(well=KRASdata[["E03"]])
aWell <- sdRain(aWell, cMethod="Cluster")
cl <- wellClassification(aWell)
table(cl$Cluster)
table(cl$ClusterSdRain)

## Compare the types of droplets in multiple wells for the "Cluster" class
## and then with rain.
krasPlate <- ddpcrPlate(wells=KRASdata[c("E03", "H03", "C04", "F04")])
krasPlate <- sdRain(krasPlate, cMethod="Cluster")
plateSummary(krasPlate, cMethod="Cluster")[, c(1:5)]
plateSummary(krasPlate, cMethod="ClusterSdRain")[, c(1:5)]

## The 'errorLevel' parameter can changed.
krasPlate <- sdRain(krasPlate, cMethod="Cluster", errorLevel=4)
plateSummary(krasPlate, cMethod="ClusterSdRain")[, c(1:5)]

## The 'errorLevel' parameter can also be changed for each cluster.
krasPlate <- sdRain(krasPlate, cMethod="Cluster",
                    errorLevel=list(NN=5, NP=5, PN=4, PP=3))
plateSummary(krasPlate, cMethod="ClusterSdRain")[, c(1:5)]

}
\references{
This approach was described in {Jones, M., Williams, J.,
Gaertner, K., Phillips, R., Hurst, J., & Frater, J. (2014). Low copy target
detection by Droplet Digital PCR through application of a novel open access
bioinformatic pipeline, "definetherain." Journal of Virological Methods,
202(100), 46--53. \url{http://doi.org/10.1016/j.jviromet.2014.02.020}}
}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
