% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddpcrPlate.R
\name{plateClassificationMethod}
\alias{plateClassificationMethod}
\alias{plateClassName}
\alias{plateClassificationName}
\alias{plateClassMethod}
\alias{plateClassificationMethod,ddpcrPlate-method}
\alias{plateClassificationMethod<-}
\alias{plateClassificationMethod<-,ddpcrPlate-method}
\alias{commonClassificationMethod}
\alias{commonClassificationMethod,ddpcrPlate-method}
\title{Set or retrieve the classification method strings for multiple wells.}
\usage{
plateClassificationMethod(theObject)

\S4method{plateClassificationMethod}{ddpcrPlate}(theObject)

plateClassificationMethod(theObject, cMethod) <- value

\S4method{plateClassificationMethod}{ddpcrPlate}(theObject, cMethod) <- value

commonClassificationMethod(theObject)

\S4method{commonClassificationMethod}{ddpcrPlate}(theObject)
}
\arguments{
\item{theObject}{A \code{\link{ddpcrPlate}} object.}

\item{cMethod}{This should represent existing classification method(s) for
all wells in \code{theObject}. It can be given in the form of a:
\itemize{
  \item Character vector. If this vector is shorter than the length of
  \code{wells}, this vector's elements will be repeated.
  \item List of character vectors.
}}

\item{value}{New classification method(s) in the same form as
\code{cMethod}.}
}
\value{
\code{plateClassificationMethod} returns a list of character strings
corresponding to the classification methods.

\code{commonClassificationMethod} returns a vector of character
strings indicating which classification methods appear in all wells.
}
\description{
\code{plateClassificationMethod} retrieves multiple classification methods
that have been assigned to a \code{ddpcrPlate} object.

\code{commonClassificationMethod} retrieves the classification
methods common to all the wells in the given \code{ddpcrPlate} object.
}
\examples{
## Get the classification methods for the KRASdata dataset.
krasPlate <- ddpcrPlate(wells=KRASdata)
plateClassificationMethod(krasPlate)

## Change the "Cluster" column to "QS".
plateClassificationMethod(krasPlate, "Cluster") <- "QS"
plateClassificationMethod(krasPlate)

## Usually, all of the classification names are the same for all wells. We
## use the \code{commonClassificationMethod} method to retrieve the ones
## common to all wells.
commonClassificationMethod(krasPlate)

}
\seealso{
\code{\link{plateClassification}} for the classifications.
}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
