% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddpcrWell.R
\docType{class}
\name{ddpcrWell-class}
\alias{ddpcrWell-class}
\alias{.ddpcrWell}
\alias{ddpcrWell}
\alias{ddpcrWell,data.frame-method}
\alias{ddpcrWell,character-method}
\alias{ddpcrWell,missing-method}
\alias{ddpcrWell,ddpcrWell-method}
\alias{show,ddpcrWell-method}
\title{An S4 class for the classification of a single well in a ddPCR
experiment.}
\usage{
ddpcrWell(well)

\S4method{ddpcrWell}{data.frame}(well)

\S4method{ddpcrWell}{character}(well)

\S4method{ddpcrWell}{missing}(well)

\S4method{ddpcrWell}{ddpcrWell}(well)

\S4method{show}{ddpcrWell}(object)
}
\arguments{
\item{well}{A well with columns \code{Ch1.Amplitude} and
\code{Ch2.Amplitude} and optional classification columns. This can be in the
form of a data frame or the path to a droplet amplitude CSV file.}

\item{object}{Any R object}
}
\value{
A \code{ddpcrWell} object with the given droplets in the well.
}
\description{
An S4 class for the classification of a single well in a ddPCR
experiment.

The constructor for the \code{ddpcrWell} class.
}
\section{Slots}{

\describe{
\item{\code{dropletAmplitudes}}{A data frame with columns \code{Ch1.Amplitude}
and \code{Ch2.Amplitude} corresponding to all the droplets in the ddPCR
well.}

\item{\code{classification}}{A vector of factors, where the levels are given by
\code{ddpcr$classesRain}.}
}}

\examples{
## A \code{ddpcrWell} object can be created from data from a list of data
## frames.
ddpcrWell(KRASdata[[1]])

## An CSV file of droplet amplitudes can also be loaded.
ampFile <- system.file("extdata/amplitudes/sample_B03_Amplitude.csv",
                       package="twoddpcr")
ddpcrWell(ampFile)

}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}

Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
